/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.toolkit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileToolkit {
    public static String[] FILE_ENCODING = new String[]{"DEFAULT", "ASCII", "Cp1252", "ISO8859_1", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF8", "UTF-16"};

    public static Reader getReaderForFile(File file, String string) throws IOException {
        InputStreamReader inputStreamReader = string == null || "DEFAULT".equals(string) ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), string);
        return inputStreamReader;
    }

    public static Writer getWriterForFile(File file, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = string == null || "DEFAULT".equals(string) ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
        return outputStreamWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromFileName(String string, String string2) throws Throwable {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(string);
        if (file.exists()) {
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null || "DEFAULT".equals(string2) ? new FileReader(string) : new InputStreamReader((InputStream)new FileInputStream(string), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string3 = null;
                String string4 = System.getProperty("line.separator");
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(string4);
                    }
                    stringBuffer.append(string3);
                }
            }
            finally {
                bufferedReader.close();
            }
        } else if (string.indexOf("://") > -1) {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            return FileToolkit.getContentFromInputStream(inputStream, string2);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromInputStream(InputStream inputStream, String string) throws Throwable {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            int n;
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string == null || "DEFAULT".equals(string) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuffer.toString();
    }

    public static String getPathForObject(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                uRL = jarURLConnection.getJarFileURL();
                String string2 = uRL.toExternalForm();
                string2 = string2.replaceAll("%20", " ");
                if (string2.startsWith("file://")) {
                    return string2.substring(6);
                }
                if (string2.startsWith("file:/")) {
                    return string2.substring(5);
                }
                return string2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return uRL.toExternalForm();
    }

    public static String toURL(File file) {
        return "file://" + file.toString();
    }

    public static String toFile(URL uRL) {
        File file;
        String string = uRL.toExternalForm();
        string = string.replace("%20", " ");
        String string2 = null;
        if (string.startsWith("file://") && (file = new File(string.substring(7))).exists()) {
            string2 = file.toString();
            return string2;
        }
        if (string.startsWith("file:/") && (file = new File(string.substring(6))).exists()) {
            string2 = file.toString();
            return string2;
        }
        if (string.startsWith("file:") && (file = new File(string.substring(5))).exists()) {
            string2 = file.toString();
        }
        return string2;
    }

    public static String getContentFromURL(URL uRL) throws Throwable {
        return FileToolkit.getContentFromInputStream(uRL.openStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFromURL(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToZip(File file, String string, String string2, String string3) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            fileInputStream.read(byArray);
        }
        finally {
            fileInputStream.close();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        ZipEntry zipEntry = new ZipEntry(string);
        if (string.indexOf("/") > -1 && !string.startsWith("/")) {
            string = "/" + string;
        }
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(string3.getBytes(string2));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            String string4 = zipEntry.getName();
            if (string4.indexOf("/") > -1 && !string4.startsWith("/")) {
                string4 = "/" + string4;
            }
            if (string4.equals(string)) continue;
            System.out.println("WRITE " + string4);
            zipEntry = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray2 = new byte[1024];
            while ((n = zipInputStream.read(byArray2)) != -1) {
                zipOutputStream.write(byArray2, 0, n);
            }
        }
        zipOutputStream.flush();
        zipOutputStream.finish();
        zipOutputStream.close();
        return true;
    }

    public static boolean sameFileName(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return FileToolkit.fileNameFromUri(string).equalsIgnoreCase(FileToolkit.fileNameFromUri(string2));
    }

    public static String fileNameFromUri(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }
}

