/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class MultiChoiceButton
extends JButton
implements ActionListener {
    private Insets finalInsets = null;
    static EmptyIcon ICON = new EmptyIcon();

    public MultiChoiceButton(Action action) {
        super(action);
    }

    public void addNotify() {
        super.addNotify();
        this.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeActionListener(this);
    }

    public Insets getInsets() {
        if (this.finalInsets != null) {
            return this.finalInsets;
        }
        Insets insets = super.getInsets();
        insets.right += ICON.getIconWidth();
        this.finalInsets = insets;
        return this.finalInsets;
    }

    private void showPopup(JComponent jComponent, Action action) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 1; i <= 10 && action.getValue("label" + i) != null; ++i) {
            String string = (String)action.getValue("label" + i);
            String string2 = (String)action.getValue("cmd" + i);
            JMenuItem jMenuItem = new JMenuItem(action);
            jMenuItem.setText(string);
            jMenuItem.setActionCommand(string2);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(jComponent, 0, jComponent.getHeight());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ICON.paintIcon(this, graphics, 0, 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.showPopup(this, this.getAction());
    }

    public static void main(String[] stringArray) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.putValue("Name", "TEST");
        abstractAction.putValue("label1", "Test 1");
        abstractAction.putValue("label2", "Test 2");
        abstractAction.putValue("cmd1", "CMD 1");
        abstractAction.putValue("cmd2", "CMD 2");
        JFrame jFrame = new JFrame();
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new MultiChoiceButton(abstractAction));
        jFrame.getContentPane().add((Component)jToolBar, "North");
        jFrame.setSize(100, 100);
        jFrame.setVisible(true);
    }

    public static class EmptyIcon
    implements Icon {
        private final int height;
        private final int width;
        private Polygon p;

        public EmptyIcon() {
            this.height = 10;
            this.width = 10;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            if (this.p == null) {
                this.p = new Polygon(new int[]{1, 1 + this.width / 2, 1 + this.width}, new int[]{this.height / 4, 3 * this.height / 4, this.height / 4}, 3);
                this.p.translate(n + component.getWidth() - this.width - 4, n2 + (component.getHeight() - this.height) / 2);
            }
            graphics.fillPolygon(this.p);
        }
    }
}

