/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui.text;

import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.framework.ui.text.FileTextFieldHandler;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class DefaultTextFieldHandler
implements FileTextFieldHandler {
    public String selectResource(FileTextField fileTextField, String string, boolean bl, boolean bl2, boolean bl3, String[] stringArray, String string2) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] == null) {
            stringArray = null;
        }
        final String[] stringArray2 = stringArray;
        JFileChooser jFileChooser = new JFileChooser();
        if (bl && bl2) {
            jFileChooser.setFileSelectionMode(2);
        } else if (bl) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(0);
        }
        if (stringArray2 != null) {
            jFileChooser.setFileFilter(new FileFilter(){

                public String getDescription() {
                    String string = "";
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (i > 0) {
                            string = string + " ";
                        }
                        string = string + "*." + stringArray2[i];
                    }
                    return string;
                }

                public boolean accept(File file) {
                    boolean bl = file.isDirectory();
                    if (!bl) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (!file.toString().toLowerCase().endsWith(stringArray2[i])) continue;
                            return true;
                        }
                    }
                    return bl;
                }
            });
        }
        if (string != null && string.length() > 0) {
            jFileChooser.setCurrentDirectory(new File(string).getParentFile());
        } else if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        if (bl3) {
            if (jFileChooser.showOpenDialog(fileTextField) == 0) {
                return jFileChooser.getSelectedFile().toString();
            }
            return null;
        }
        if (jFileChooser.showSaveDialog(fileTextField) == 0) {
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    public void createResource(String string) {
        if (this.wrongPathCheck(string)) {
            return;
        }
        boolean bl = new File(string).mkdirs();
        if (!bl) {
            if (new File(string).exists()) {
                JOptionPane.showMessageDialog(null, "This path " + string + " already exists " + string, "Wrong operation", 2);
            } else {
                JOptionPane.showMessageDialog(null, "Cannot create " + string, "Wrong operation", 2);
            }
        }
    }

    private boolean wrongPathCheck(String string) {
        if (string == null) {
            JOptionPane.showMessageDialog(null, "No path", "Wrong operation", 2);
            return true;
        }
        return false;
    }

    public void deleteResource(String string) {
        if (this.wrongPathCheck(string)) {
            return;
        }
        if (JOptionPane.showConfirmDialog(null, "Delete " + string + " ?") == 0) {
            File file = new File(string);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(null, "Path " + string + " doesn't exist", "Wrong operation", 2);
            } else {
                boolean bl = file.delete();
                if (!bl) {
                    if (file.isDirectory() && file.list() != null) {
                        JOptionPane.showMessageDialog(null, "This path " + string + " is not empty", "Wrong operation", 2);
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot delete " + string, "Wrong operation", 2);
                    }
                }
            }
        }
    }

    public boolean isCreateResourceManaged() {
        return true;
    }

    public boolean isDeleteResourceManaged() {
        return false;
    }
}

