/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor.ui;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.RefactorManager;
import com.japisoft.framework.xml.refactor.elements.RefactorModel;
import com.japisoft.framework.xml.refactor.elements.RefactorObj;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import com.sun.org.apache.bcel.internal.util.ClassLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RefactorUI
extends JPanel
implements ListSelectionListener {
    private SimpleNode context;
    private JList l;
    private JCheckBox rcb;
    private RefactorModel mapRefTable = new RefactorModel();
    private Icon SYSTEM_ICON = new ImageIcon(ClassLoader.getSystemResource((String)"images/pawn_glass_blue.png"));
    private Icon OTHER_ICON = new ImageIcon(ClassLoader.getSystemResource((String)"images/pawn_glass_green.png"));

    public RefactorUI(SimpleNode simpleNode) {
        this.context = simpleNode;
        this.init();
        this.setPreferredSize(new Dimension(550, 250));
    }

    private void init() {
        this.setLayout(new BorderLayout());
        DefaultListModel defaultListModel = new DefaultListModel();
        this.prepareRefactorModel(defaultListModel);
        this.l = new JList(defaultListModel);
        this.l.setCellRenderer(new CustomListRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.l);
        this.l.setBorder(new EmptyBorder(5, 5, 5, 5));
        jScrollPane.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add((Component)jScrollPane, "West");
        if (this.context != null) {
            this.rcb = new JCheckBox("Relative Refactoring to " + this.context.getXPathLocation());
            this.rcb.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.add((Component)this.rcb, "South");
        }
    }

    private void prepareRefactorModel(DefaultListModel defaultListModel) {
        for (int i = 0; i < RefactorManager.getRefactorCount(); ++i) {
            defaultListModel.addElement(RefactorManager.getRefactor(i));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.l.getSelectionModel().addListSelectionListener(this);
        this.l.setSelectedIndex(0);
    }

    public void removeNotify() {
        super.removeNotify();
        this.l.getSelectionModel().removeListSelectionListener(this);
    }

    public RefactorModel getModel() {
        if (this.rcb != null) {
            this.mapRefTable.setRelativeRefactoring(this.rcb.isSelected());
        }
        return this.mapRefTable;
    }

    public void setModel(RefactorModel refactorModel) {
        this.mapRefTable = refactorModel;
        this.l.getSelectionModel().removeListSelectionListener(this);
        this.l.getSelectionModel().setSelectionInterval(0, 0);
        this.updateTable((String)this.l.getSelectedValue());
        this.l.getSelectionModel().addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateTable(this.l.getSelectedValue().toString());
    }

    private void updateTable(String string) {
        if (!this.mapRefTable.containsKey(string)) {
            this.mapRefTable.put(string, this.buildTable(string));
        }
        JTable jTable = (JTable)this.mapRefTable.get(this.l.getSelectedValue().toString());
        for (int i = 1; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JScrollPane)) continue;
            this.remove(this.getComponent(i));
            break;
        }
        this.add((Component)new JScrollPane(jTable), "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private JTable buildTable(String string) {
        RefactorTable refactorTable = new RefactorTable(string);
        if (this.context != null) {
            RefactorObj refactorObj = RefactorManager.getRefactor(string);
            refactorObj.initTable(refactorTable, this.context);
        }
        return refactorTable;
    }

    public void dispose() {
        this.context = null;
    }

    class CustomListRenderer
    extends DefaultListCellRenderer {
        CustomListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (jComponent instanceof JLabel) {
                RefactorObj refactorObj = (RefactorObj)object;
                if (refactorObj.isDefault()) {
                    ((JLabel)jComponent).setIcon(RefactorUI.this.SYSTEM_ICON);
                    jComponent.setForeground(Color.black);
                } else {
                    ((JLabel)jComponent).setIcon(RefactorUI.this.OTHER_ICON);
                    jComponent.setForeground(new Color(50, 200, 50));
                }
            }
            return jComponent;
        }
    }
}

