/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.multipanes.view;

import com.japisoft.multipanes.MultiPanes;
import com.japisoft.multipanes.TitledPane;
import com.japisoft.multipanes.TitledPaneView;
import com.japisoft.multipanes.view.DefaultTitledPaneView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ArrowTitledPaneView
implements TitledPaneView {
    private MultiPanes panes;

    public void init(MultiPanes multiPanes) {
        this.panes = multiPanes;
        if (UIManager.getColor("multipanes.arrowTitledPaneView.rightArrowColor") == null) {
            UIManager.put("multipanes.arrowTitledPaneView.rightArrowColor", Color.black);
        }
        if (UIManager.getColor("multipanes.arrowTitledPaneView.downArrowColor") == null) {
            UIManager.put("multipanes.arrowTitledPaneView.downArrowColor", Color.gray);
        }
        if (UIManager.getIcon("multipanes.arrowTitledPaneView.rightArrowIcon") == null) {
            UIManager.put("multipanes.arrowTitledPaneView.rightArrowIcon", new ArrowRight());
        }
        if (UIManager.getIcon("multipanes.arrowTitledPaneView.downArrowIcon") == null) {
            UIManager.put("multipanes.arrowTitledPaneView.downArrowIcon", new ArrowDown());
        }
    }

    public JComponent buildPanelHeader(TitledPane titledPane) {
        return DefaultTitledPaneView.updateButtonForUIManager(this.panes, titledPane, new JButton(new ButtonAction(titledPane)), false);
    }

    public void updateView(JComponent jComponent, TitledPane titledPane, boolean bl) {
        for (int i = 0; i < this.panes.getComponentCount(); ++i) {
            ButtonAction buttonAction;
            JButton jButton;
            if (!(this.panes.getComponent(i) instanceof JButton) || !((jButton = (JButton)this.panes.getComponent(i)).getAction() instanceof ButtonAction) || (buttonAction = (ButtonAction)jButton.getAction()).pane != titledPane) continue;
            buttonAction.openedState = bl;
            buttonAction.putValue("SmallIcon", buttonAction.getValue("SmallIcon"));
            DefaultTitledPaneView.updateButtonForUIManager(this.panes, titledPane, jButton, bl);
            break;
        }
    }

    static class ArrowDown
    implements Icon {
        ArrowDown() {
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("multipanes.arrowTitledPaneView.downArrowColor"));
            graphics.fillPolygon(new int[]{4, 16, 10}, new int[]{8, 8, 20}, 3);
        }
    }

    static class ArrowRight
    implements Icon {
        ArrowRight() {
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(UIManager.getColor("multipanes.arrowTitledPaneView.rightArrowColor"));
            graphics.fillPolygon(new int[]{4, 16, 4}, new int[]{8, 14, 20}, 3);
        }
    }

    class ButtonAction
    extends AbstractAction
    implements PropertyChangeListener {
        private TitledPane pane;
        boolean openedState = false;

        public ButtonAction(TitledPane titledPane) {
            this.pane = titledPane;
            titledPane.addPropertyChangeListener(this);
            this.setEnabled(titledPane.isEnabled());
            this.openedState = titledPane == ArrowTitledPaneView.this.panes.getOpenedTitledPane();
        }

        public Object getValue(String string) {
            if ("Name" == string) {
                return this.pane.getTitle();
            }
            if ("SmallIcon" == string) {
                return this.openedState ? UIManager.getIcon("multipanes.arrowTitledPaneView.downArrowIcon") : UIManager.getIcon("multipanes.arrowTitledPaneView.rightArrowIcon");
            }
            if ("ShortDescription" == string) {
                return this.pane.getToolTip();
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ArrowTitledPaneView.this.panes.getOpenedTitledPane() == this.pane) {
                ArrowTitledPaneView.this.panes.close(this.pane);
            } else {
                ArrowTitledPaneView.this.panes.open(this.pane);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            } else {
                this.putValue(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

