/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component;

import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class CustomFocusManager
extends FocusManager {
    private AbstractXMLFormComponent getAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof AbstractXMLFormComponent) {
            return (AbstractXMLFormComponent)component;
        }
        return this.getAncestor(component.getParent());
    }

    private JScrollPane getScrollPaneAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JScrollPane) {
            return (JScrollPane)component;
        }
        return this.getScrollPaneAncestor(component.getParent());
    }

    public void focusNextComponent(Component component) {
        component = CustomFocusManager.getCurrentManager().getFocusOwner();
        AbstractXMLFormComponent abstractXMLFormComponent = this.getAncestor(component);
        if (abstractXMLFormComponent != null) {
            abstractXMLFormComponent.nextXMLFormFocus();
            abstractXMLFormComponent.scrollRectToVisible(abstractXMLFormComponent.getBounds());
        } else {
            super.focusNextComponent(component);
        }
    }

    public void focusPreviousComponent(Component component) {
        component = CustomFocusManager.getCurrentManager().getFocusOwner();
        JScrollPane jScrollPane = this.getScrollPaneAncestor(component);
        if (jScrollPane != null) {
            if (component.getParent() instanceof JViewport) {
                component = component.getParent().getParent();
            }
            Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), jScrollPane);
            rectangle.translate(0, -100);
            jScrollPane.getViewport().scrollRectToVisible(rectangle);
        }
    }
}

