/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component.editable;

import com.japisoft.framework.internationalization.Traductor;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.framework.xml.grammar.GrammarText;
import com.japisoft.framework.xml.grammar.GrammarType;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.container.GridComponent;
import com.japisoft.xmlform.component.editable.XMLEditableComponent;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.designer.properties.PropertyDescriptor;
import com.japisoft.xmlform.designer.properties.PropertyDescriptorImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEnumComponent
extends XMLEditableComponent
implements ActionListener {
    private JComboBox cb = new JComboBox();
    private String[] values = null;
    private HashMap<String, String> dictionnary = null;

    public XMLEnumComponent(boolean bl, ComponentContext componentContext) {
        super(bl, componentContext);
        if (!bl) {
            this.add((Component)new JLabel(" "), "North");
        }
        this.add((Component)this.cb, "Center");
        this.setPreferredSize(new Dimension(200, 4 * GridComponent.getGridSize()));
    }

    @Override
    public void setTooltip(String string) {
        super.setTooltip(string);
        this.cb.setToolTipText(string);
    }

    private void checkEnumValues() {
        GrammarNode grammarNode;
        GrammarType grammarType;
        if (this.designMode && this.cb != null && (grammarType = (grammarNode = this.node.getSource()).getType()) != null) {
            List<GrammarNode> list = grammarType.getValues();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (GrammarNode grammarNode2 : list) {
                if (!(grammarNode2 instanceof GrammarText)) continue;
                GrammarText grammarText = (GrammarText)grammarNode2;
                arrayList.add(grammarText.getValue());
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            this.setValues(stringArray);
        }
    }

    @Override
    public void setGrammarNode(GrammarNodeTreeNode grammarNodeTreeNode) {
        super.setGrammarNode(grammarNodeTreeNode);
        this.checkEnumValues();
    }

    @Override
    protected void setDOM(Node node) {
        if (node instanceof Text) {
            node = node.getParentNode();
        }
        super.setDOM(node);
        this.domText = null;
        Node node2 = this.getDOMText();
        String string = node2.getNodeValue();
        if (this.dictionnary != null) {
            string = this.dictionnary.get(string);
        }
        this.cb.setSelectedItem(string);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.designMode) {
            this.cb.addMouseListener(this);
            this.cb.addMouseMotionListener(this);
        } else {
            this.cb.addActionListener(this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.designMode) {
            this.cb.removeMouseListener(this);
            this.cb.removeMouseMotionListener(this);
        } else {
            this.cb.removeActionListener(this);
        }
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] stringArray) {
        this.firePropertyChange("values", this.values, stringArray);
        this.values = stringArray;
        this.cb.removeAllItems();
        this.cb.addItem(Traductor.traduce("nos", "No Selection"));
        for (String string : stringArray) {
            if (this.dictionnary != null) {
                string = this.dictionnary.get(string);
            }
            this.cb.addItem(string);
        }
    }

    public HashMap<String, String> getDictionnary() {
        if (this.dictionnary == null) {
            this.dictionnary = new HashMap();
        }
        if (this.values != null) {
            for (String string : this.values) {
                if (this.dictionnary.containsKey(string)) continue;
                this.dictionnary.put(string, string);
            }
        }
        return this.dictionnary;
    }

    public void setDictionnary(HashMap<String, String> hashMap) {
        this.firePropertyChange("dictionnary", null, hashMap);
        this.dictionnary = hashMap;
        if (this.values != null) {
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            defaultComboBoxModel.addElement(this.cb.getItemAt(0));
            for (String string : this.values) {
                if (hashMap.containsKey(string)) {
                    defaultComboBoxModel.addElement(hashMap.get(string));
                    continue;
                }
                defaultComboBoxModel.addElement(string);
            }
            this.cb.setModel(defaultComboBoxModel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.cb.getSelectedIndex();
        if (n == 0) {
            this.deleteDOMText();
        } else {
            String string = (String)this.cb.getSelectedItem();
            if (this.dictionnary != null) {
                for (Map.Entry<String, String> entry : this.dictionnary.entrySet()) {
                    if (!string.equals(entry.getValue())) continue;
                    string = entry.getKey();
                    break;
                }
            }
            this.getDOMText().setNodeValue(string);
        }
    }

    @Override
    protected void prepareProperties(ArrayList<PropertyDescriptor> arrayList) throws Exception {
        super.prepareProperties(arrayList);
        arrayList.add(new PropertyDescriptorImpl("dictionnary", HashMap.class, this));
    }
}

