/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.xmlpad.ToolBarModelListener;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionGroup;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.TreeAction;
import com.japisoft.xmlpad.action.XMLAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;

public class ToolBarModel {
    private final Object SEPARATOR = null;
    private Vector content = new Vector();
    private XMLContainer container;
    private Vector vListeners = null;
    private boolean cEnableChange = false;

    public ToolBarModel(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    public void dispose() {
        this.container = null;
    }

    public void addToolBarModelListener(ToolBarModelListener toolBarModelListener) {
        if (this.vListeners == null) {
            this.vListeners = new Vector();
        }
        this.vListeners.add(toolBarModelListener);
    }

    public void removeToolBarModelListener(ToolBarModelListener toolBarModelListener) {
        if (this.vListeners != null) {
            this.vListeners.remove(toolBarModelListener);
        }
    }

    public void setEnabledListener(boolean bl) {
        this.cEnableChange = bl;
        if (bl) {
            this.fireNotification();
        }
    }

    private void fireNotification() {
        for (int i = 0; i < this.vListeners.size(); ++i) {
            ToolBarModelListener toolBarModelListener = (ToolBarModelListener)this.vListeners.get(i);
            toolBarModelListener.updateActions(this.content);
        }
    }

    public int size() {
        return this.content.size();
    }

    public void addAction(Action action) {
        this.content.add(action);
        if (action instanceof XMLAction) {
            ((XMLAction)action).setXMLContainer(this.container);
            ((XMLAction)action).setXMLEditor(this.container.getEditor());
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeAction(Action action, boolean bl) {
        this.content.remove(action);
        if (bl && action instanceof XMLAction) {
            ((XMLAction)action).dispose();
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeAction(Action action) {
        this.removeAction(action, false);
    }

    public void insertActionAt(Action action, int n) {
        this.content.insertElementAt(action, n);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public Action getActionAt(int n) {
        return (Action)this.content.elementAt(n);
    }

    public boolean isAction(int n) {
        return !this.isSeparator(n);
    }

    public void addSeparator() {
        this.content.add(this.SEPARATOR);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void insertSeparatorAt(int n) {
        this.content.insertElementAt(this.SEPARATOR, n);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeSeparator(int n) {
        if (this.content.get(n) == this.SEPARATOR) {
            this.content.removeElementAt(n);
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public boolean isSeparator(int n) {
        return this.content.get(n) == this.SEPARATOR;
    }

    public static void resetToolBarModel(ToolBarModel toolBarModel) {
        Enumeration enumeration = ActionModel.getGroups();
        while (enumeration.hasMoreElements()) {
            ActionGroup actionGroup = (ActionGroup)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < actionGroup.size(); ++i) {
                XMLAction xMLAction = (XMLAction)actionGroup.get(i);
                if (!xMLAction.isToolbarable()) continue;
                toolBarModel.addAction(xMLAction);
                bl = true;
            }
            if (!enumeration.hasMoreElements() || !bl) continue;
            toolBarModel.addSeparator();
        }
    }

    public static void resetTreeToolBarModel(ToolBarModel toolBarModel) {
        ActionGroup actionGroup = ActionModel.getGroupByName(ActionModel.TREE_GROUP);
        if (actionGroup == null) {
            return;
        }
        for (int i = 0; i < actionGroup.size(); ++i) {
            TreeAction treeAction;
            if (!(actionGroup.get(i) instanceof TreeAction) || !(treeAction = (TreeAction)actionGroup.get(i)).isTreeToolBarable()) continue;
            toolBarModel.addAction((XMLAction)((Object)treeAction));
        }
    }
}

