/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.tools.ParserToolkit;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.ui.MultiChoiceButton;
import com.japisoft.xmlpad.Accessibility;
import com.japisoft.xmlpad.BasicDocumentColorAccessibility;
import com.japisoft.xmlpad.BasicSchemaAccessibility;
import com.japisoft.xmlpad.BasicUIAccessibility;
import com.japisoft.xmlpad.CaretListener;
import com.japisoft.xmlpad.ComponentFactory;
import com.japisoft.xmlpad.DTDMapperUsage;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.DocumentColorAccessibility;
import com.japisoft.xmlpad.DocumentStateListener;
import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.LocationEvent;
import com.japisoft.xmlpad.LocationListener;
import com.japisoft.xmlpad.PopupModel;
import com.japisoft.xmlpad.PopupModelListener;
import com.japisoft.xmlpad.SchemaAccessibility;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.ToolBarModel;
import com.japisoft.xmlpad.ToolBarModelListener;
import com.japisoft.xmlpad.UIAccessibility;
import com.japisoft.xmlpad.UIStateListener;
import com.japisoft.xmlpad.ViewRowComponent;
import com.japisoft.xmlpad.XMLContainerAccessibility;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.XMLIntegrity;
import com.japisoft.xmlpad.XMLPadProperties;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.MultipleChoice;
import com.japisoft.xmlpad.action.TreeAction;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.action.file.LoadAction;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.editor.XMLTemplate;
import com.japisoft.xmlpad.elementview.ElementView;
import com.japisoft.xmlpad.elementview.ElementViewContext;
import com.japisoft.xmlpad.error.ErrorListener;
import com.japisoft.xmlpad.error.ErrorManager;
import com.japisoft.xmlpad.error.ErrorView;
import com.japisoft.xmlpad.helper.HelperManager;
import com.japisoft.xmlpad.helper.SchemaHelperManager;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.handler.system.ClosingTagHandler;
import com.japisoft.xmlpad.helper.handler.system.DefaultEntityHandler;
import com.japisoft.xmlpad.helper.handler.system.DefaultSystemHandler;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import com.japisoft.xmlpad.look.LookManager;
import com.japisoft.xmlpad.nodeeditor.Editor;
import com.japisoft.xmlpad.nodeeditor.EditorContext;
import com.japisoft.xmlpad.nodeeditor.EditorModel;
import com.japisoft.xmlpad.tree.TreeListeners;
import com.japisoft.xmlpad.tree.TreeState;
import com.japisoft.xmlpad.tree.renderer.FastTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLContainer
implements IXMLPanel {
    private TreeListeners treeListeners;
    private XMLEditor firstEditor;
    private JToolBar toolbar;
    JToolBar treeToolbar;
    private ToolBarModel toolBarModel;
    private ToolBarModel treeToolBarModel;
    private PopupModel popupModel;
    private PopupModel treePopupModel;
    private ComponentFactory cf;
    private XMLDocumentInfo documentInfo;
    private XMLIntegrity documentIntegrity;
    private boolean realTimeTreeOnTextChange = true;
    private CustomToolBarModelListener toolbarModelListener;
    private CustomToolBarModelListener treeToolBarModelListener;
    private CustomPopupModelListener popupModelListener;
    private CustomTreePopupModelListener treePopupModelListener;
    private XMLEditor currentEditor;
    protected JScrollPane sp1;
    protected JScrollPane sp2;
    private IView view;
    private ElementView elementView = null;
    private XMLTemplate template = null;
    private HelperManager helperManager = null;
    private SchemaHelperManager syntaxhelper = null;
    private JScrollPane editorScrollPane;
    private JPanel panelEditor;
    JSplitPane mainSplitPane;
    private JTree tree;
    private JViewport rowHeader = null;
    private ScrollBarListener listenerSP = null;
    boolean hasTreeDelegate = false;
    private ArrayList navigation = null;
    private int indexNavigation = -1;
    private int navigationLimit = 10;
    BookmarkContext bookmarks;
    private String currentDTD;
    private String currentDTDRoot;
    private String currentSchema;
    private String currentSchemaRoot;
    private SchemaLocator relaxNGValidationLocation = null;
    private boolean previousModifiedState = true;
    private JPopupMenu popup = null;
    private JPopupMenu treePopup = null;
    private boolean autoFocus = true;
    private boolean setTextCalled = false;
    private boolean editable = true;
    private boolean editableDocumentMode = true;
    int lastTreeDividerLocation = 40;
    private boolean treeAvailable = true;
    private boolean toolBarVisible = true;
    boolean treeToolBarAvailable = true;
    private boolean toolBarAvailable = true;
    private boolean popupAvailable = true;
    private boolean treePopupAvailable = true;
    boolean addNotifyDone = false;
    private double initialDividerLocation = 0.2;
    private double elementViewDividerLocation = 0.5;
    private UIStateListener uiListener = null;
    private boolean initialized = false;
    JSplitPane elementSplitPane = null;
    private boolean autoNewDocument = true;
    boolean disposeMode = false;
    boolean disposeAction = true;
    private ErrorManager errorManager = null;
    private ErrorView errorView = null;
    private boolean showErrorPanel = false;
    private boolean showLocationPanel = true;
    private LocationPanel cLocationPanel = null;
    private boolean statusBarEnabled = true;
    private boolean errorPanelEnabled = true;
    private SimpleNode rootNode;
    private JSplitPane cSP = null;
    private XMLEditor secondEditor = null;
    private JScrollPane secondEditorScrollPane = null;
    TreeState treeState = null;
    private boolean hasFocus = true;
    private boolean split = false;
    private com.japisoft.xmlpad.editor.EditorContext commonContext = new XMLEditorContext();
    private HashMap htProperties;
    Accessibility access = null;
    SchemaAccessibility schemaAccess = null;
    UIAccessibility uiAccess = null;
    DocumentColorAccessibility documentColorAccess = null;
    static ResourceBundle bundle;
    static boolean hasBundleError;
    private CaretListener caretListener;
    private LocationListener locationListener;

    protected XMLContainer(ComponentFactory componentFactory) {
        this.cf = componentFactory;
        this.prepareUI();
        ActionModel.resetActionState(this);
    }

    public XMLContainer() {
        this(ComponentFactory.getFactory());
    }

    public XMLContainer(boolean bl) {
        this();
        this.setAutoDisposeMode(bl);
    }

    public void setUIReady(boolean bl) {
    }

    public Action getAction(String string) {
        return null;
    }

    public JComponent getView() {
        return this.getInnerView().getFinalView();
    }

    public IView getInnerView() {
        if (this.view == null) {
            this.view = ComponentFactory.getFactory().getUIContainer(this);
        }
        return this.view;
    }

    public XMLContainer getMainContainer() {
        return this;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public XMLContainer getSubContainer(String string) {
        return this;
    }

    public boolean reload() {
        if (this.getCurrentDocumentLocation() == null) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    LoadAction.loadInBuffer(XMLContainer.this, XMLContainer.this.getCurrentDocumentLocation());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    public boolean hasSyntaxCompletion() {
        return this.getHelperManager().isEnabled();
    }

    public void setSyntaxCompletion(boolean bl) {
        this.getHelperManager().setEnabled(bl);
    }

    void setElementView(ElementView elementView) {
        this.elementView = elementView;
    }

    ElementView getElementView() {
        return this.elementView;
    }

    public void setTemplate(XMLTemplate xMLTemplate) {
        this.template = xMLTemplate;
    }

    public XMLTemplate getTemplate() {
        XMLTemplate xMLTemplate = null;
        if (this.template == null) {
            xMLTemplate = new XMLTemplate();
            xMLTemplate.setComment(" Your document, created at : " + new Date());
        } else {
            xMLTemplate = this.template;
        }
        if (this.getDefaultDTDLocation() != null) {
            xMLTemplate.setSchema(null);
            xMLTemplate.setDtd(this.getDefaultDTDLocation());
            xMLTemplate.setRootNode(this.getDefaultDTDRoot());
        } else if (this.getDefaultSchemaLocation() != null) {
            xMLTemplate.setSchema(this.getDefaultSchemaLocation());
            xMLTemplate.setDtd(null);
            xMLTemplate.setRootNode(this.getDefaultSchemaRoot());
        }
        return xMLTemplate;
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        if (xMLDocumentInfo == null) {
            this.documentInfo = null;
            return;
        }
        this.documentInfo = xMLDocumentInfo.cloneDocument();
        if (xMLDocumentInfo.getTemplate() != null) {
            XMLTemplate xMLTemplate = new XMLTemplate();
            xMLTemplate.setRawContent(xMLDocumentInfo.getTemplate());
            this.setTemplate(xMLTemplate);
        }
        this.getSyntaxHelper().setExternalDTDCommentFile(xMLDocumentInfo.getDTDExternalCommentFile());
        this.getSyntaxHelper().setDefaultNamespace(xMLDocumentInfo.getDefaultNamespace());
        if (xMLDocumentInfo.getHelperHandlers() != null) {
            this.getHelperManager().resetHandlers(xMLDocumentInfo.getHelperHandlers(), xMLDocumentInfo.isAssistantAppendMode());
        } else if (xMLDocumentInfo.hasDefaultAssistant()) {
            this.installDefaultHelperHandlers(this.getHelperManager());
        }
    }

    public XMLDocumentInfo getDocumentInfo() {
        if (this.documentInfo == null) {
            this.documentInfo = new XMLDocumentInfo();
        }
        return this.documentInfo;
    }

    public HelperManager getHelperManager() {
        if (this.helperManager == null) {
            this.helperManager = new HelperManager(this);
            this.installDefaultHelperHandlers(this.helperManager);
        }
        return this.helperManager;
    }

    protected void installDefaultHelperHandlers(HelperManager helperManager) {
        ArrayList<AbstractHelperHandler> arrayList = new ArrayList<AbstractHelperHandler>();
        arrayList.add(new DefaultSystemHandler());
        arrayList.add(new DefaultEntityHandler());
        arrayList.add(new ClosingTagHandler());
        helperManager.resetHandlers(arrayList, false);
    }

    public ToolBarModel getToolBarModel() {
        if (this.toolBarModel == null) {
            this.toolBarModel = new ToolBarModel(this);
            ToolBarModel.resetToolBarModel(this.toolBarModel);
        }
        return this.toolBarModel;
    }

    public PopupModel getPopupModel() {
        if (this.popupModel == null) {
            this.popupModel = new PopupModel(this);
            PopupModel.resetPopupModel(this.popupModel);
        }
        return this.popupModel;
    }

    public PopupModel getTreePopupModel() {
        if (this.treePopupModel == null) {
            this.treePopupModel = new PopupModel(this);
            PopupModel.resetTreePopupModel(this.treePopupModel);
        }
        return this.treePopupModel;
    }

    public ToolBarModel getTreeToolBarModel() {
        if (this.treeToolBarModel == null) {
            this.treeToolBarModel = new ToolBarModel(this);
            this.resetDefaultTreeToolBarModel(this.treeToolBarModel);
        }
        return this.treeToolBarModel;
    }

    protected void resetDefaultTreeToolBarModel(ToolBarModel toolBarModel) {
        ToolBarModel.resetTreeToolBarModel(this.treeToolBarModel);
    }

    public SchemaHelperManager getSyntaxHelper() {
        if (this.syntaxhelper == null) {
            this.syntaxhelper = new SchemaHelperManager(this.getErrorManager(), this.getHelperManager());
        }
        return this.syntaxhelper;
    }

    protected JScrollPane prepareScrollPaneTextEditor(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        if (this.sp1 == null) {
            this.sp1 = jScrollPane;
        } else {
            this.sp2 = jScrollPane;
        }
        return jScrollPane;
    }

    private void prepareUI() {
        this.panelEditor = this.cf.getNewPanel();
        this.panelEditor.setLayout(new BorderLayout());
        this.editorScrollPane = this.prepareScrollPaneTextEditor(this.firstEditor == null ? (this.firstEditor = this.cf.getNewXMLEditor(this.commonContext)) : this.firstEditor);
        this.panelEditor.add((Component)this.editorScrollPane, "Center");
        this.firstEditor.setXMLContainer(this);
        boolean bl = true;
        try {
            bl = "true".equals(XMLPadProperties.getProperty("tree", "true"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (bl && this.treeAvailable) {
            this.setElementView(this.cf.getNewElementView(this));
        }
        this.prepareScrollPane(this.editorScrollPane);
    }

    public void setDisplayRowHeader(boolean bl) {
        if (!bl) {
            this.rowHeader = this.editorScrollPane.getRowHeader();
            this.editorScrollPane.setRowHeader(null);
        } else if (this.rowHeader != null) {
            this.editorScrollPane.setRowHeader(this.rowHeader);
        }
    }

    private void prepareScrollPane(JScrollPane jScrollPane) {
        ViewRowComponent viewRowComponent = new ViewRowComponent(this);
        JViewport jViewport = new JViewport();
        jViewport.setView(viewRowComponent);
        jViewport.setBackground(this.firstEditor.getBackground());
        jScrollPane.setRowHeader(jViewport);
        if (this.listenerSP == null) {
            this.listenerSP = new ScrollBarListener();
        }
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(this.listenerSP);
        this.getErrorManager().addErrorListener(viewRowComponent);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTreeDelegate(JTree jTree) {
        this.tree = jTree;
        this.hasTreeDelegate = true;
    }

    public com.japisoft.xmlpad.editor.EditorContext getEditorContext() {
        return this.commonContext;
    }

    public void setNavigationHistoryLimit(int n) {
        this.navigationLimit = n;
    }

    public int getNavigationHistoryLimit() {
        return this.navigationLimit;
    }

    public void addNavigationHistoryPath(String string) {
        if (this.navigation == null) {
            this.navigation = new ArrayList();
        }
        this.navigation.add(string);
        if (this.navigation.size() > this.navigationLimit) {
            this.navigation.remove(0);
        }
        this.indexNavigation = this.navigation.size();
        this.updateNavigationHistoryState();
    }

    public void removeNavigationHistoryPath(String string) {
        if (this.navigation != null) {
            this.navigation.remove(string);
            this.indexNavigation = this.navigation.size();
            this.updateNavigationHistoryState();
        }
    }

    public void updateNavigationHistoryState() {
        if (this.navigation == null || this.navigation.size() == 0) {
            ActionModel.setEnabledAction(ActionModel.TREE_NEXT_ACTION, false);
            ActionModel.setEnabledAction(ActionModel.TREE_PREVIOUS_ACTION, false);
            ActionModel.setEnabledAction(ActionModel.TREE_CLEANHISTORY_ACTION, false);
        } else {
            ActionModel.setEnabledAction(ActionModel.TREE_PREVIOUS_ACTION, this.indexNavigation > 0);
            ActionModel.setEnabledAction(ActionModel.TREE_NEXT_ACTION, this.indexNavigation < this.navigation.size() - 1);
            ActionModel.setEnabledAction(ActionModel.TREE_ADDHISTORY_ACTION, true);
            ActionModel.setEnabledAction(ActionModel.TREE_CLEANHISTORY_ACTION, true);
        }
    }

    public void cleanNavigationHistoryPath() {
        this.navigation = null;
        this.indexNavigation = -1;
        this.updateNavigationHistoryState();
    }

    public String previousNavigationHistoryPath() {
        if (this.navigation == null) {
            return null;
        }
        if (this.indexNavigation > 0) {
            --this.indexNavigation;
            this.updateNavigationHistoryState();
            return (String)this.navigation.get(this.indexNavigation);
        }
        return null;
    }

    public String nextNavigationHistoryPath() {
        if (this.navigation == null) {
            return null;
        }
        if (this.indexNavigation < this.navigation.size() - 1) {
            ++this.indexNavigation;
            this.updateNavigationHistoryState();
            return (String)this.navigation.get(this.indexNavigation);
        }
        return null;
    }

    public boolean searchAndParseDTD() {
        return ((XMLDocument)this.getEditor().getDocument()).parseDTD();
    }

    public boolean searchAndParseSchema() {
        return ((XMLDocument)this.getEditor().getDocument()).parseSchema();
    }

    public void setFocusView(boolean bl) {
        this.getInnerView().setFocusView(bl);
    }

    public void requestFocus() {
        this.getView().requestFocus();
    }

    public void setBookmarkContext(BookmarkContext bookmarkContext) {
        this.bookmarks = bookmarkContext;
    }

    public BookmarkContext getBookmarkContext() {
        return this.bookmarks;
    }

    String getCurrentDTD() {
        return this.currentDTD;
    }

    String getCurrentDTDRoot() {
        return this.currentDTDRoot;
    }

    public boolean hasSchema() {
        return this.currentDTD != null || this.currentSchema != null;
    }

    void setDefaultDTD(String string, String string2) {
        this.getDocumentInfo().setDefaultDTD(string, string2);
        this.setDTD(null, null, -1);
    }

    void setDefaultDTD(String string, URL uRL) {
        this.getDocumentInfo().setDefaultDTD(string, uRL);
        try {
            this.getSyntaxHelper().setExternalDTDCommentFile(this.getDocumentInfo().getDTDExternalCommentFile());
            this.getSyntaxHelper().setDTDContent(string, new SchemaLocator(uRL));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String getCurrentSchema() {
        return this.currentSchema;
    }

    String getCurrentSchemaRoot() {
        return this.currentSchemaRoot;
    }

    void setSchema(String string, String[] stringArray, String[] stringArray2, int n) {
        if (stringArray2 == null) {
            string = this.getDocumentInfo().getDefaultSchemaRoot();
            if (this.getDocumentInfo().getDefaultSchemaLocation() != null) {
                stringArray2 = new String[]{this.getDocumentInfo().getDefaultSchemaLocation()};
            }
        }
        this.currentSchemaRoot = string;
        this.currentSchema = stringArray2 != null && stringArray2.length > 0 ? stringArray2[0] : null;
        this.getSyntaxHelper().setSchemaLocation(this.getCurrentDocumentLocation(), stringArray, stringArray2, this.currentSchemaRoot, n, (EntityResolver)this.getProperty("entityresolver"));
        if (this.currentSchema == null && this.getDocumentInfo().getDefaultDTDLocation() != null) {
            this.setDTD(null, null, -1);
        } else if (this.currentSchema == null && this.relaxNGValidationLocation != null) {
            this.getSyntaxHelper().setRelaxNGLocation(this.relaxNGValidationLocation);
        }
    }

    void setDTD(String string, SchemaLocator schemaLocator) throws Exception {
        this.getSyntaxHelper().setExternalDTDCommentFile(this.getDocumentInfo().getDTDExternalCommentFile());
        this.getSyntaxHelper().setDTDContent(string, schemaLocator);
    }

    void setDTD(String string, String string2, int n) {
        Object object;
        if (string2 == null) {
            string = this.getDocumentInfo().getDefaultDTDRoot();
            string2 = this.getDocumentInfo().getDefaultDTDLocation();
            if (string != null && string2 == null && (object = this.getDocumentInfo().getDefaultDTDURL()) != null) {
                try {
                    SchemaLocator schemaLocator = new SchemaLocator(((URL)object).openStream());
                    schemaLocator.schemaDeclarationLine = n;
                    this.getSyntaxHelper().setExternalDTDCommentFile(this.getDocumentInfo().getDTDExternalCommentFile());
                    this.getSyntaxHelper().setDTDContent(string, schemaLocator);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.currentDTD = string2;
        this.currentDTDRoot = string;
        if (this.currentDTD != null && SharedProperties.DEFAULT_ENTITY_RESOLVER != null) {
            try {
                object = SharedProperties.DEFAULT_ENTITY_RESOLVER.resolveEntity(null, this.currentDTD);
                if (object != null && !(object instanceof DTDMapperUsage)) {
                    SchemaLocator schemaLocator = null;
                    if (((InputSource)object).getCharacterStream() != null) {
                        schemaLocator = new SchemaLocator(((InputSource)object).getCharacterStream());
                    } else if (((InputSource)object).getByteStream() != null) {
                        schemaLocator = new SchemaLocator(((InputSource)object).getByteStream());
                    } else if (((InputSource)object).getSystemId() != null) {
                        schemaLocator = new SchemaLocator(((InputSource)object).getSystemId());
                    }
                    if (schemaLocator != null) {
                        this.getSyntaxHelper().setExternalDTDCommentFile(this.getDocumentInfo().getDTDExternalCommentFile());
                        this.getSyntaxHelper().setDTDContent(this.currentDTDRoot, schemaLocator);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getSyntaxHelper().setDTDLocation(this.getCurrentDocumentLocation(), this.currentDTD, this.currentDTDRoot, n);
        if (this.currentDTD == null && this.relaxNGValidationLocation != null) {
            this.getSyntaxHelper().setRelaxNGLocation(this.relaxNGValidationLocation);
        }
    }

    String getDefaultDTDRoot() {
        return this.getDocumentInfo().getDefaultDTDRoot();
    }

    String getDefaultDTDLocation() {
        return this.getDocumentInfo().getDefaultDTDLocation();
    }

    String getDTDLocation(boolean bl) {
        File file;
        if (this.getCurrentDocumentLocation() != null && this.getCurrentDocumentLocation().indexOf("://") == -1 && this.currentDTD != null && (file = new File(new File(this.getCurrentDocumentLocation()).getParentFile(), this.currentDTD)).exists()) {
            return file.toString();
        }
        return this.currentDTD;
    }

    String getDefaultSchemaLocation() {
        return this.getDocumentInfo().getDefaultSchemaLocation();
    }

    String getDefaultSchemaRoot() {
        return this.getDocumentInfo().getDefaultSchemaRoot();
    }

    void setDefaultSchema(String string, String string2) {
        this.getDocumentInfo().setDefaultSchema(string, string2);
        this.getSyntaxHelper().setSchemaLocation(this.getCurrentDocumentLocation(), new String[]{null}, new String[]{string2}, string, -1, null);
    }

    void setRelaxNGValidationLocation(SchemaLocator schemaLocator) {
        if (schemaLocator == null) {
            this.relaxNGValidationLocation = null;
            this.getSyntaxHelper().setRelaxNGLocation(null);
        } else {
            this.relaxNGValidationLocation = schemaLocator;
            this.getSyntaxHelper().setRelaxNGLocation(this.relaxNGValidationLocation);
        }
    }

    SchemaLocator getRelaxNGValidationLocation() {
        return this.relaxNGValidationLocation;
    }

    String getSchemaLocation(boolean bl) {
        File file;
        if (this.getCurrentDocumentLocation() != null && this.getCurrentDocumentLocation().indexOf("://") == -1 && this.currentSchema != null && (file = new File(new File(this.getCurrentDocumentLocation()).getParentFile(), this.currentSchema)).exists()) {
            return file.toString();
        }
        return this.currentSchema;
    }

    public void setCurrentDocumentLocation(String string) {
        this.getDocumentInfo().setCurrentDocumentLocation(string);
    }

    public String getCurrentDocumentLocation() {
        return this.getDocumentInfo().getCurrentDocumentLocation();
    }

    public URL getCurrentDocumentLocationURL() {
        String string = this.getCurrentDocumentLocation();
        try {
            if (string != null && string.indexOf("://") == -1) {
                File file = new File(string);
                return file.toURL();
            }
            if (string != null) {
                return new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public Object getCurrentDocumentLocationArg() {
        return this.getDocumentInfo().getCurrentDocumentLocationArg();
    }

    public void setCurrentDocumentLocationArg(Object object) {
        this.getDocumentInfo().setCurrentDocumentLocationArg(object);
    }

    public void setModifiedState(boolean bl) {
        if (bl == this.previousModifiedState) {
            return;
        }
        this.previousModifiedState = bl;
        this.firstEditor.resetDocumentState(bl);
        if (this.secondEditor != null) {
            this.secondEditor.resetDocumentState(bl);
        }
        ActionModel.setEnabledAction(ActionModel.SAVE_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.SAVEAS_ACTION, bl);
        if (!bl) {
            this.notifyDocumentVersion(true);
        }
    }

    public boolean isModified() {
        return this.previousModifiedState;
    }

    public JPopupMenu getCurrentPopup() {
        return this.popup;
    }

    public JPopupMenu getCurrentTreePopup() {
        return this.treePopup;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public XMLEditor getEditor() {
        if (this.currentEditor != null) {
            return this.currentEditor;
        }
        if (this.firstEditor == null) {
            this.firstEditor = this.cf.getNewXMLEditor(this.commonContext);
        }
        return this.firstEditor;
    }

    public int getCaretPosition() {
        if (this.firstEditor == null) {
            return -1;
        }
        return this.firstEditor.getCaretPosition();
    }

    public void setAutoFocus(boolean bl) {
        this.autoFocus = bl;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        int n;
        if (this.getElementView() != null) {
            this.getElementView().updateView(null);
        }
        this.setTextCalled = true;
        boolean bl2 = this.getDocumentIntegrity().isProtectTag();
        if (bl2) {
            this.getDocumentIntegrity().setProtectTag(false);
        }
        if (this.firstEditor == null) {
            throw new RuntimeException("Illegal XMLContainer usage, please check if the autoDispose mode is disabled ?");
        }
        this.getErrorManager().notifyNoError(true);
        this.getErrorManager().notifyNoError(false);
        this.removeErrorPanel(false);
        this.removeErrorPanel(true);
        this.firstEditor.resetDocumentState(true);
        this.firstEditor.removeHighlightedLines();
        this.rootNode = null;
        if (this.firstEditor.getParent() != null && this.firstEditor.getParent().getParent() != null) {
            ViewRowComponent viewRowComponent = (ViewRowComponent)((JScrollPane)this.firstEditor.getParent().getParent()).getRowHeader().getView();
            viewRowComponent.setCurrentNode(null);
            viewRowComponent.repaint();
        }
        boolean bl3 = this.isEditableDocumentMode();
        this.setEditableDocumentMode(true);
        this.firstEditor.setText(string);
        this.setEditableDocumentMode(bl3);
        if (bl2) {
            this.getDocumentIntegrity().setProtectTag(true);
        }
        this.firstEditor.getUndoManager().discardAllEdits();
        if (this.secondEditor != null) {
            this.secondEditor.getUndoManager().discardAllEdits();
        }
        ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, false);
        if (this.autoFocus) {
            this.getEditor().requestFocus();
        }
        try {
            if (this.getDocumentInfo().isSelectFirstTagAfterReading()) {
                n = ((XMLDocument)this.firstEditor.getDocument()).nextTag(0);
                if (n >= 0) {
                    this.firstEditor.setCaretPosition(n);
                }
            } else {
                this.firstEditor.setCaretPositionWithoutNotification(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        n = this.searchAndParseDTD();
        if (n == 0) {
            n = this.searchAndParseSchema();
        }
        this.notifyDocumentVersion(bl);
        this.setModifiedState(false);
        this.cleanNavigationHistoryPath();
    }

    public String getText() {
        return this.firstEditor.getText();
    }

    public XMLDocument getDocument() {
        if (this.firstEditor == null) {
            return null;
        }
        return (XMLDocument)this.firstEditor.getDocument();
    }

    public boolean hasTextSelection() {
        return this.getEditor().getSelectionEnd() > this.getEditor().getSelectionStart();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.firstEditor.setEditable(bl);
        if (this.secondEditor != null) {
            this.secondEditor.setEditable(bl);
        }
        ActionModel.setEnabledAction(ActionModel.COMMENT_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.CUT_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.PASTE_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.NEW_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.FORMAT_ACTION, bl);
        ActionModel.setEnabledAction(ActionModel.LOAD_ACTION, bl);
    }

    public void setEditableDocumentMode(boolean bl) {
        this.editableDocumentMode = bl;
    }

    public boolean isEditableDocumentMode() {
        return this.editableDocumentMode;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setTreeVisible(boolean bl) {
        if (this.tree != null) {
            if (bl) {
                this.mainSplitPane.setDividerLocation(this.lastTreeDividerLocation);
            } else {
                this.lastTreeDividerLocation = this.mainSplitPane.getDividerLocation();
                this.mainSplitPane.setDividerLocation(0);
            }
        }
    }

    public boolean isTreeVisible() {
        if (this.tree == null) {
            return false;
        }
        return this.mainSplitPane.getDividerLocation() > 1;
    }

    public void setTreeAvailable(boolean bl) {
        this.treeAvailable = bl;
    }

    public boolean isTreeAvailable() {
        return this.treeAvailable;
    }

    public void setToolBarVisible(boolean bl) {
        if (!this.toolBarAvailable) {
            return;
        }
        this.toolBarVisible = bl;
        if (this.toolbar != null) {
            if (!bl) {
                this.getView().remove(this.toolbar);
            } else {
                this.getView().add((Component)this.toolbar, "North");
            }
        }
        this.getView().invalidate();
        this.getView().validate();
    }

    public boolean isToolBarVisible() {
        if (!this.toolBarAvailable) {
            return false;
        }
        return this.toolBarVisible;
    }

    public void setToolBarAvailable(boolean bl) {
        this.toolBarAvailable = bl;
    }

    public boolean isToolBarAvailable() {
        return this.toolBarAvailable;
    }

    public void setPopupAvailable(boolean bl) {
        this.popupAvailable = bl;
    }

    public boolean isPopupAvailable() {
        return this.popupAvailable;
    }

    public void setTreePopupAvailable(boolean bl) {
        this.treePopupAvailable = bl;
    }

    public boolean isTreePopupAvailable() {
        if (this.tree == null) {
            return false;
        }
        return this.treePopupAvailable;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = this.cf.getNewToolBar();
        return jToolBar;
    }

    protected JPopupMenu createPopupMenu() {
        return this.cf.getNewPopupMenu();
    }

    public void resetDefaultToolBarActions() {
        ActionModel.resetActionState(this);
        if (!this.toolBarAvailable) {
            return;
        }
        ToolBarModel.resetToolBarModel(this.toolBarModel);
    }

    public void setEnabledTreeLocationForCaret(boolean bl) {
        this.firstEditor.setEnabledTreeLocationForCaret(bl);
    }

    public void setEnabledRealTimeStructureChanged(boolean bl) {
        this.firstEditor.setEnabledRealTimeStructureChanged(bl);
    }

    protected double getInitialDividerLocation() {
        return this.initialDividerLocation;
    }

    protected double getElementViewInitialDividerLocation() {
        return this.elementViewDividerLocation;
    }

    void setInitialTreeTextDividerLocation(double d) {
        this.initialDividerLocation = d;
    }

    void setElementViewDividerLocation(double d) {
        this.elementViewDividerLocation = d;
    }

    public void setUIStateListener(UIStateListener uIStateListener) {
        this.uiListener = uIStateListener;
    }

    protected void initOnce(JComponent jComponent) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Debug.debug("INIT");
        this.initModels();
        VisibleStateAction visibleStateAction = new VisibleStateAction();
        jComponent.addComponentListener(visibleStateAction);
        jComponent.addHierarchyListener(visibleStateAction);
        this.initUI(jComponent);
        if (this.getDocumentInfo().isRealTimeTree()) {
            this.treeListeners = new TreeListeners(this);
        }
        if (this.tree != null && this.treeListeners != null) {
            this.treeListeners.init();
        }
        if (!this.setTextCalled && this.autoNewDocument) {
            ActionModel.activeActionByName(ActionModel.NEW_ACTION);
        }
        if (this.setTextCalled) {
            Debug.debug("synchronized tree");
            if (this.getTreeListeners() != null) {
                this.getTreeListeners().notifyStructureChanged();
            }
        } else {
            Debug.debug("non synchronized tree");
        }
        if (this.elementView != null) {
            this.elementView.init(new BasicElementViewContext());
        }
        ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, false);
        ActionModel.setEnabledAction(ActionModel.REDO_ACTION, false);
        if (this.uiListener != null) {
            this.uiListener.ready();
        }
        this.initOnceErrorBinding();
    }

    protected void initOnceErrorBinding() {
        if (this.treeListeners != null && this.tree != null) {
            this.getErrorManager().addErrorListener(this.treeListeners.getTreeErrorListener());
        }
        if (this.elementView != null) {
            this.getErrorManager().addErrorListener(this.elementView);
        }
        this.getErrorManager().addErrorListener(this.getErrorView());
        this.getErrorManager().addErrorListener(new ParsingErrorListener());
        this.getErrorManager().addErrorListener(this.getSyntaxHelper());
        this.getErrorManager().addErrorListener(this.getEditor());
    }

    protected void initUI(JComponent jComponent) {
        jComponent.setLayout(new BorderLayout());
        if (this.getDocumentInfo().isTreeAvailable() && this.treeAvailable && !this.hasTreeDelegate) {
            this.tree = this.cf.getNewTree();
            this.tree.setScrollsOnExpand(true);
            LookManager.install(this, this.tree);
            this.mainSplitPane = this.cf.getNewHorizontalSplitPane();
            this.mainSplitPane.setDividerLocation(0);
            JComponent jComponent2 = null;
            JComponent jComponent3 = null;
            if (!this.treeToolBarAvailable) {
                jComponent3 = new JScrollPane(this.tree);
            } else {
                jComponent3 = new JPanel();
                jComponent3.setLayout(new BorderLayout());
                jComponent3.add((Component)this.treeToolbar, "North");
                this.treeToolbar.setFloatable(false);
                jComponent3.add((Component)new JScrollPane(this.tree), "Center");
                this.treeToolBarModel.setEnabledListener(true);
            }
            jComponent3.setPreferredSize(new Dimension(100, 50));
            if (this.elementView == null) {
                jComponent2 = jComponent3;
            } else {
                JSplitPane jSplitPane = new JSplitPane(0);
                jSplitPane.setOneTouchExpandable(true);
                jSplitPane.setDividerLocation(0);
                this.elementSplitPane = jSplitPane;
                jSplitPane.setTopComponent(jComponent3);
                if (this.elementView.autoScroll()) {
                    jSplitPane.setBottomComponent(this.elementView.getView());
                } else {
                    jSplitPane.setBottomComponent(new JScrollPane(this.elementView.getView()));
                }
                jComponent2 = jSplitPane;
            }
            this.mainSplitPane.setLeftComponent(jComponent2);
            this.mainSplitPane.setRightComponent(this.panelEditor);
            jComponent.add((Component)this.mainSplitPane, "Center");
            if (this.treeListeners != null) {
                this.treeListeners.notifyStructureChanged();
            }
        } else {
            jComponent.add((Component)this.panelEditor, "Center");
        }
        if (this.toolBarAvailable) {
            this.toolbar = this.createToolBar();
            jComponent.add((Component)this.toolbar, "North");
            this.toolbarModelListener = new CustomToolBarModelListener(this.toolbar);
            this.toolBarModel.addToolBarModelListener(this.toolbarModelListener);
            this.toolBarModel.setEnabledListener(true);
        }
    }

    protected void initModels() {
        if (this.toolBarAvailable) {
            this.toolBarModel = this.getToolBarModel();
        }
        if (this.popupAvailable && !this.useCustomPopupMenu()) {
            this.popupModel = this.getPopupModel();
        }
        if (this.treePopupAvailable) {
            this.treePopupModel = this.getTreePopupModel();
        }
        if (this.treeToolBarAvailable && !this.hasTreeDelegate) {
            this.treeToolbar = this.cf.getNewToolBar();
            this.treeToolBarModelListener = new CustomToolBarModelListener(this.treeToolbar);
            this.getTreeToolBarModel().addToolBarModelListener(this.treeToolBarModelListener);
        }
        if (this.popupAvailable) {
            this.popup = this.createPopupMenu();
            if (!this.useCustomPopupMenu()) {
                this.popupModelListener = new CustomPopupModelListener();
                this.popupModel.addPopupModelListener(this.popupModelListener);
                this.popupModel.setEnabledListener(true);
            }
        } else if (this.useCustomPopupMenu()) {
            this.popup = this.getCurrentPopup();
        }
        if (this.treePopupAvailable) {
            this.treePopup = this.createPopupMenu();
            this.treePopupModelListener = new CustomTreePopupModelListener();
            this.treePopupModel.addPopupModelListener(this.treePopupModelListener);
            this.treePopupModel.setEnabledListener(true);
        }
    }

    public void setAutoNewDocument(boolean bl) {
        this.autoNewDocument = bl;
    }

    protected boolean useCustomPopupMenu() {
        return false;
    }

    public void dispose() {
        JobManager.addJob(new DisposeJob());
    }

    public void setAutoDisposeMode(boolean bl) {
        this.disposeMode = bl;
    }

    public void setDisposeAction(boolean bl) {
        this.disposeAction = bl;
    }

    public boolean isAutoDisposeMode() {
        return this.disposeMode;
    }

    public ErrorManager getErrorManager() {
        if (this.errorManager == null) {
            this.errorManager = new ErrorManager();
        }
        return this.errorManager;
    }

    void setErrorView(ErrorView errorView) {
        if (this.errorView != null) {
            this.getErrorManager().removeErrorListener(this.errorView);
        }
        this.errorView = errorView;
        if (errorView != null) {
            this.getErrorManager().addErrorListener(errorView);
        }
    }

    ErrorView getErrorView() {
        if (this.errorView == null) {
            this.errorView = ComponentFactory.getFactory().getDefaultErrorView();
        }
        return this.errorView;
    }

    protected void showErrorPanel() {
        if (!this.errorPanelEnabled || this.getErrorManager().hasLastErrorOnTheFly() && !this.getErrorView().isShownForOnTheFly()) {
            return;
        }
        this.removeLocationPanel();
        this.showErrorPanel = true;
        this.getErrorView().addErrorSelectionListener(this.getUIAccessibility().getEditor());
        this.panelEditor.add((Component)this.getErrorView().getView(), "South");
        this.panelEditor.invalidate();
        this.panelEditor.validate();
        this.panelEditor.repaint();
        this.getErrorView().initOnceAdded();
        this.getEditor().setCaretColor(Color.red);
    }

    protected void removeErrorPanel(boolean bl) {
        if (!this.errorPanelEnabled) {
            return;
        }
        if (this.showErrorPanel) {
            if (!this.errorView.isShownForOnTheFly() && bl) {
                return;
            }
            this.getErrorView().removeErrorSelectionListener(this.getUIAccessibility().getEditor());
            this.panelEditor.remove(this.errorView.getView());
            this.showErrorPanel = false;
            if (this.showLocationPanel) {
                this.showLocationPanel();
            }
            this.panelEditor.invalidate();
            this.panelEditor.validate();
            this.panelEditor.repaint();
            this.getEditor().setCaretColor(Color.black);
        }
    }

    private void showLocationPanel() {
        if (this.showErrorPanel) {
            return;
        }
        if (this.cLocationPanel == null) {
            this.cLocationPanel = new LocationPanel();
        }
        this.panelEditor.add((Component)this.cLocationPanel, "South");
        this.panelEditor.invalidate();
        this.panelEditor.validate();
        this.panelEditor.repaint();
        this.showLocationPanel = true;
    }

    private void removeLocationPanel() {
        if (this.cLocationPanel == null) {
            return;
        }
        this.showLocationPanel = false;
        this.panelEditor.remove(this.cLocationPanel);
        this.panelEditor.repaint();
    }

    public boolean editNode() {
        return this.editNode(this.getCurrentElementNode());
    }

    public boolean editNode(SimpleNode simpleNode) {
        Editor editor;
        if (simpleNode == null) {
            return false;
        }
        SimpleNode simpleNode2 = simpleNode;
        if (!EditorModel.accept(simpleNode2)) {
            return false;
        }
        int n = simpleNode2.getStartingOffset();
        int n2 = simpleNode2.getStoppingOffset();
        if (simpleNode2.isTag()) {
            ++n2;
        }
        if ((editor = EditorModel.getEditorForNode(simpleNode2)) == null) {
            return false;
        }
        try {
            EditorContext editorContext = new EditorContext(this, simpleNode2, this.getEditor().getText(n, n2 - n));
            editor.edit(editorContext);
            if (editorContext.getResult() != null) {
                this.getEditor().select(n, n2);
                this.getEditor().replaceSelection(editorContext.getResult());
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    public void setStatusBarAvailable(boolean bl) {
        this.statusBarEnabled = bl;
    }

    public boolean isStatusBarAvailable() {
        return this.statusBarEnabled;
    }

    public void setErrorPanelAvailable(boolean bl) {
        this.errorPanelEnabled = bl;
    }

    public boolean isErrorPanelAvailable() {
        return this.errorPanelEnabled;
    }

    public void setLastNodeParsed(SimpleNode simpleNode) {
        this.rootNode = simpleNode;
    }

    public SimpleNode getCurrentNode() {
        return this.getEditor().getCurrentNodeLocation();
    }

    public SimpleNode getCurrentElementNode() {
        SimpleNode simpleNode = this.getCurrentNode();
        if (simpleNode == null) {
            return null;
        }
        if (simpleNode.isText()) {
            return simpleNode.getSimpleParent();
        }
        return simpleNode;
    }

    public SimpleNode getRootNode() {
        if (this.treeListeners == null) {
            return null;
        }
        return this.rootNode;
    }

    public void updateNodeLocation(SimpleNode simpleNode) {
        if (!this.showErrorPanel && this.statusBarEnabled) {
            if (simpleNode != null) {
                this.showLocationPanel();
                this.cLocationPanel.setLocation(simpleNode);
            } else {
                if (this.cLocationPanel != null) {
                    this.panelEditor.remove(this.cLocationPanel);
                }
                this.getView().invalidate();
                this.getView().validate();
                this.showLocationPanel = false;
            }
        }
        if (this.treeListeners != null) {
            this.treeListeners.resetTreeLocation(simpleNode);
        }
        if (this.firstEditor != null && !this.hasErrorMessage()) {
            ViewRowComponent viewRowComponent = (ViewRowComponent)((JScrollPane)this.firstEditor.getParent().getParent()).getRowHeader().getView();
            viewRowComponent.setCurrentNode(simpleNode);
            viewRowComponent.repaint();
        }
        if (this.elementView != null) {
            this.elementView.updateView(simpleNode);
        }
    }

    protected void showLocation(SimpleNode simpleNode) {
        if (this.getCurrentNode() == simpleNode) {
            return;
        }
        this.updateNodeLocation(simpleNode);
    }

    public TreeListeners getTreeListeners() {
        return this.treeListeners;
    }

    public void setEnabledTreeLocation(boolean bl) {
        this.firstEditor.setEnabledTreeLocationForCaret(bl);
    }

    public boolean isEnabledTreeLocation() {
        return this.firstEditor.isEnabledTreeLocationForCaret();
    }

    public void resetEditor(XMLEditor xMLEditor) {
        this.currentEditor = xMLEditor;
    }

    public void focus() {
        if (this.hasTreeDelegate && this.treeState != null && this.treeListeners != null) {
            this.treeListeners.setState(this.treeState);
        }
        this.hasFocus = true;
    }

    public void unfocus() {
        if (this.hasTreeDelegate) {
            this.treeState = this.treeListeners.getState();
        }
        this.hasFocus = false;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setSplit(boolean bl, boolean bl2) {
        if (bl) {
            this.split(bl2);
        } else {
            this.unSplit();
        }
    }

    public boolean isSplit() {
        return this.split;
    }

    public void split(boolean bl) {
        this.splitInner(bl);
    }

    void splitInner(boolean bl) {
        if (this.split) {
            this.unSplit();
        } else {
            boolean bl2 = this.disposeMode;
            this.disposeMode = false;
            this.panelEditor.remove(this.editorScrollPane);
            this.disposeMode = bl2;
            this.cSP = bl ? this.cf.getNewVerticalSplitPane() : this.cf.getNewHorizontalSplitPane();
            this.cSP.setTopComponent(this.editorScrollPane);
            this.secondEditor = this.cf.getNewXMLEditor(this.commonContext);
            this.secondEditorScrollPane = this.prepareScrollPaneTextEditor(this.secondEditor);
            this.cSP.setBottomComponent(this.secondEditorScrollPane);
            this.prepareScrollPane(this.secondEditorScrollPane);
            this.secondEditor.setXMLContainer(this);
            this.panelEditor.add((Component)this.cSP, "Center");
            this.cSP.setDividerLocation(this.panelEditor.getHeight() / 2);
            this.split = true;
            this.panelEditor.invalidate();
            this.panelEditor.validate();
            this.getView().repaint();
            this.secondEditor.setAutoResetAction(this.firstEditor.isAutoResetAction());
            this.secondEditor.resetDocument((XMLDocument)this.firstEditor.getDocument());
            this.secondEditor.setEditable(this.isEditable());
        }
    }

    public void setAutoResetAction(boolean bl) {
        this.firstEditor.setAutoResetAction(bl);
        if (this.secondEditor != null) {
            this.secondEditor.setAutoResetAction(bl);
        }
    }

    public void unSplit() {
        if (this.isSplit()) {
            boolean bl = this.isAutoDisposeMode();
            this.setAutoDisposeMode(false);
            this.secondEditor.dispose();
            this.panelEditor.remove(this.cSP);
            this.cSP.remove(this.editorScrollPane);
            this.panelEditor.add((Component)this.editorScrollPane, "Center");
            this.panelEditor.invalidate();
            this.panelEditor.validate();
            this.getView().repaint();
            this.cSP = null;
            this.secondEditorScrollPane = null;
            this.secondEditor = null;
            this.currentEditor = null;
            ActionModel.resetActionState(this);
            this.split = false;
            this.setAutoDisposeMode(bl);
        }
    }

    public void resetProperties(HashMap hashMap) {
        this.htProperties = hashMap;
    }

    public void setProperty(String string, Object object) {
        if (this.htProperties == null) {
            this.htProperties = new HashMap();
        }
        if (object != null) {
            this.htProperties.put(string, object);
        } else {
            this.htProperties.remove(string);
        }
    }

    public Object getProperty(String string) {
        if (this.htProperties != null) {
            return this.htProperties.get(string);
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.htProperties != null && this.htProperties.containsKey(string);
    }

    public Iterator getProperties() {
        if (this.htProperties == null) {
            return null;
        }
        return this.htProperties.keySet().iterator();
    }

    public Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    private void visibleAction(Component component) {
        if (component == this.getView()) {
            this.visibleAction();
        }
        if (this.elementSplitPane != null && this.mainSplitPane != null) {
            if (this.elementSplitPane.getDividerLocation() <= 0) {
                this.elementSplitPane.setDividerLocation(this.getElementViewInitialDividerLocation());
            } else {
                this.elementSplitPane.setDividerLocation(this.getElementViewInitialDividerLocation());
            }
            this.mainSplitPane.setDividerLocation((int)((double)this.getView().getWidth() * this.getInitialDividerLocation()));
            if (this.getUIAccessibility().isTreeToolBarAvailable() && this.getInitialDividerLocation() > 0.0 && this.mainSplitPane.getDividerLocation() < this.getUIAccessibility().getTreeToolBar().getPreferredSize().width) {
                this.mainSplitPane.setDividerLocation(this.getUIAccessibility().getTreeToolBar().getPreferredSize().width);
            }
            Debug.debug("Visible Action : " + this.mainSplitPane.getDividerLocation());
        }
    }

    protected void visibleAction() {
        Debug.debug("VISIBLE");
    }

    public Accessibility getAccessibility() {
        if (this.access == null) {
            this.access = new XMLContainerAccessibility(this);
        }
        return this.access;
    }

    public SchemaAccessibility getSchemaAccessibility() {
        if (this.schemaAccess == null) {
            this.schemaAccess = new BasicSchemaAccessibility(this);
        }
        return this.schemaAccess;
    }

    public UIAccessibility getUIAccessibility() {
        if (this.uiAccess == null) {
            this.uiAccess = new BasicUIAccessibility(this);
        }
        return this.uiAccess;
    }

    public DocumentColorAccessibility getDocumentColorAccessibility() {
        if (this.documentColorAccess == null) {
            this.documentColorAccess = new BasicDocumentColorAccessibility(this);
        }
        return this.documentColorAccess;
    }

    private void disposeAccessiblities() {
        if (this.access != null) {
            this.access.dispose();
        }
        if (this.uiAccess != null) {
            this.uiAccess.dispose();
        }
        if (this.documentColorAccess != null) {
            this.documentColorAccess.dispose();
        }
        if (this.schemaAccess != null) {
            this.schemaAccess.dispose();
        }
    }

    void setColorForTag(String string, Color color) {
        this.getDocumentInfo().setColorForTag(string, color);
    }

    Color getColorForTag(String string) {
        return this.getDocumentInfo().getColorForTag(string);
    }

    boolean hasColorForTag(String string) {
        return this.getDocumentInfo().hasColorForTag(string);
    }

    void setColorForAttribute(String string, Color color) {
        this.getDocumentInfo().setColorForAttribute(string, color);
    }

    Color getColorForAttribute(String string) {
        return this.getDocumentInfo().getColorForAttribute(string);
    }

    boolean hasColorForAttribute(String string) {
        return this.getDocumentInfo().hasColorForAttribute(string);
    }

    void setColorForPrefix(String string, Color color) {
        this.getDocumentInfo().setColorForPrefix(string, color);
    }

    Color getColorForPrefix(String string) {
        return this.getDocumentInfo().getColorForPrefix(string);
    }

    boolean hasColorForPrefix(String string) {
        return this.getDocumentInfo().hasColorForPrefix(string);
    }

    void setBackgroundColorForPrefix(String string, Color color) {
        this.getDocumentInfo().setBackgroundColorForPrefix(string, color);
    }

    Color getBackgroundColorForPrefix(String string) {
        return this.getDocumentInfo().getBackgroundColorForPrefix(string);
    }

    boolean hasBackgroundColorForPrefix(String string) {
        return this.getDocumentInfo().hasBackgroundColorForPrefix(string);
    }

    public void refreshUndoRedoState() {
        ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, this.getEditor().getUndoManager().canUndo());
        ActionModel.setEnabledAction(ActionModel.REDO_ACTION, this.getEditor().getUndoManager().canRedo());
    }

    public UndoManager createUndoManager() {
        return new CustomUndoRedoManager();
    }

    public void showPopup(Component component, int n, int n2) {
        if (this.popup != null) {
            this.popup.show(component, n, n2);
        }
    }

    public XMLIntegrity getDocumentIntegrity() {
        if (this.documentIntegrity == null) {
            this.documentIntegrity = new XMLIntegrity();
        }
        return this.documentIntegrity;
    }

    public void setDocumentIntegrity(XMLIntegrity xMLIntegrity) {
        this.documentIntegrity = xMLIntegrity;
    }

    public boolean isRealTimeTreeOnTextChange() {
        return this.realTimeTreeOnTextChange;
    }

    public void setRealTimeTreeOnTextChange(boolean bl) {
        this.realTimeTreeOnTextChange = bl;
    }

    public static String getLocalizedMessage(String string, String string2) {
        if (hasBundleError) {
            return string2;
        }
        try {
            return bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    static ResourceBundle prepareBundle() {
        if (bundle == null) {
            if (SharedProperties.LOCALIZED_MESSAGE) {
                try {
                    bundle = ResourceBundle.getBundle(XMLContainer.class.getName());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            boolean bl = hasBundleError = bundle == null;
            if (!hasBundleError) {
                ParserToolkit.translateMessages(bundle);
            }
        }
        return bundle;
    }

    public void setCaretListener(CaretListener caretListener) {
        this.caretListener = caretListener;
    }

    public void unsetCaretListener() {
        this.caretListener = null;
    }

    public void setLocationListener(LocationListener locationListener) {
        this.locationListener = locationListener;
    }

    public void unsetLocationListener() {
        this.locationListener = null;
    }

    public void notifyLocationListener(LocationEvent locationEvent) {
        if (this.locationListener != null) {
            this.locationListener.locationChanged(locationEvent);
        }
    }

    public void notifyCaretListener(int n, int n2) {
        if (this.caretListener != null) {
            this.caretListener.caretLocation(n, n2);
        }
    }

    public void addDocumentStateListener(DocumentStateListener documentStateListener) {
        this.getInnerView().addDocumentStateListener(documentStateListener);
    }

    public void removeDocumentStateListener(DocumentStateListener documentStateListener) {
        this.getInnerView().removeDocumentStateListener(documentStateListener);
    }

    public boolean hasErrorMessage() {
        return this.getErrorManager().hasLastError();
    }

    public void notifyDocumentVersion(boolean bl) {
        Object[] objectArray = this.getInnerView().getDocumentStateListeners();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (bl) {
                ((DocumentStateListener)objectArray[i]).newDocument(this);
                continue;
            }
            ((DocumentStateListener)objectArray[i]).documentModified(this);
        }
    }

    public void prepareToSave() {
    }

    public void postLoad() {
    }

    static {
        JobManager.class.getClass();
        EditorModel.class.getClass();
        bundle = null;
        hasBundleError = false;
        XMLContainer.prepareBundle();
    }

    class BasicElementViewContext
    implements ElementViewContext {
        BasicElementViewContext() {
        }

        public Point update(String string, String string2, int n, int n2) {
            return XMLContainer.this.getDocument().updateElement(string, string2, n, n2);
        }

        public boolean isEditable() {
            return XMLContainer.this.isEditable() && JobManager.COMMON_MANAGER.isTerminated("parsing");
        }
    }

    class ScrollBarListener
    implements AdjustmentListener {
        ScrollBarListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            JViewport jViewport = ((JScrollPane)((JViewport)XMLContainer.this.getEditor().getParent()).getParent()).getRowHeader();
            if (jViewport != null) {
                jViewport.repaint();
            }
        }
    }

    class ParsingErrorListener
    implements ErrorListener {
        ParsingErrorListener() {
        }

        public void initErrorProcessing() {
        }

        public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        }

        public void notifyNoError(boolean bl) {
            XMLContainer.this.removeErrorPanel(bl);
        }

        public void stopErrorProcessing() {
            if (XMLContainer.this.hasErrorMessage()) {
                XMLContainer.this.showErrorPanel();
            }
        }
    }

    class CustomUndoRedoManager
    extends UndoManager {
        CustomUndoRedoManager() {
        }

        public void undo() {
            try {
                super.undo();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, this.canUndo());
            ActionModel.setEnabledAction(ActionModel.REDO_ACTION, this.canRedo());
        }

        public void redo() {
            try {
                super.redo();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, this.canUndo());
            ActionModel.setEnabledAction(ActionModel.REDO_ACTION, this.canRedo());
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            boolean bl = super.addEdit(undoableEdit);
            ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, this.canUndo());
            ActionModel.setEnabledAction(ActionModel.REDO_ACTION, this.canRedo());
            return bl;
        }
    }

    class CustomToolBarModelListener
    implements ToolBarModelListener {
        private JToolBar toolbar;

        public CustomToolBarModelListener(JToolBar jToolBar) {
            this.toolbar = jToolBar;
        }

        public void updateActions(Vector vector) {
            this.toolbar.removeAll();
            for (int i = 0; i < vector.size(); ++i) {
                Action action = (Action)vector.get(i);
                if (action == null) {
                    this.toolbar.addSeparator();
                    continue;
                }
                if (action instanceof MultipleChoice) {
                    this.toolbar.add(new MultiChoiceButton(action));
                    continue;
                }
                this.toolbar.add(action);
            }
        }
    }

    class CustomTreePopupModelListener
    extends CustomPopupModelListener {
        CustomTreePopupModelListener() {
        }

        protected JPopupMenu getPopupMenu() {
            return XMLContainer.this.getCurrentTreePopup();
        }
    }

    class CustomPopupModelListener
    implements PopupModelListener {
        CustomPopupModelListener() {
        }

        protected JPopupMenu getPopupMenu() {
            return XMLContainer.this.getCurrentPopup();
        }

        protected boolean isPopable(XMLAction xMLAction) {
            if (xMLAction instanceof TreeAction) {
                return ((TreeAction)((Object)xMLAction)).isTreePopable();
            }
            return xMLAction.isPopable();
        }

        public void updateActions(Vector vector) {
            this.getPopupMenu().removeAll();
            Hashtable<String, JMenu> hashtable = null;
            for (int i = 0; i < vector.size(); ++i) {
                JMenuItem jMenuItem;
                Action action = (Action)vector.get(i);
                if (action == null) {
                    if (i >= vector.size() - 1) continue;
                    XMLContainer.this.popup.addSeparator();
                    continue;
                }
                String string = action instanceof XMLAction ? (String)action.getValue("ACTION.NAME") : null;
                boolean bl = true;
                String string2 = null;
                JPopupMenu jPopupMenu = this.getPopupMenu();
                JMenu jMenu = null;
                if (action instanceof XMLAction) {
                    bl = this.isPopable((XMLAction)action);
                    string2 = ((XMLAction)action).getPopupGroup();
                    if (string2 != null) {
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, JMenu>();
                        }
                        if (!hashtable.containsKey(string2)) {
                            jMenuItem = new JMenu(string2);
                            hashtable.put(string2, (JMenu)jMenuItem);
                            jMenuItem.setIcon(new XMLAction.EmptyIcon());
                            jPopupMenu.add(jMenuItem);
                        }
                        jMenu = (JMenu)hashtable.get(string2);
                    }
                }
                if (!bl) continue;
                jMenuItem = null;
                jMenuItem = jMenu != null ? jMenu.add(action) : jPopupMenu.add(action);
                if (string == null) continue;
                jMenuItem.setText(string);
            }
        }
    }

    class LocationPanel
    extends JPanel {
        private JLabel lbl = new JLabel();

        public LocationPanel() {
            this.setLayout(new BorderLayout());
            this.add(this.lbl);
            this.lbl.setForeground(Color.black);
            this.lbl.setFont(new Font(null, 0, 12));
        }

        public void setLocation(SimpleNode simpleNode) {
            this.lbl.setText(simpleNode.getXPathLocation());
        }
    }

    class XMLEditorContext
    implements com.japisoft.xmlpad.editor.EditorContext {
        XMLEditorContext() {
        }

        public void notifyLocation(SimpleNode simpleNode) {
            XMLContainer.this.showLocation(simpleNode);
            if (XMLContainer.this.locationListener != null) {
                XMLContainer.this.notifyLocationListener(new LocationEvent(this, simpleNode));
            }
        }

        public void notifyCaretLocation(int n, int n2) {
            XMLContainer.this.notifyCaretListener(n, n2);
        }
    }

    class VisibleStateAction
    extends ComponentAdapter
    implements HierarchyListener {
        VisibleStateAction() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            XMLContainer.this.visibleAction(hierarchyEvent.getComponent());
            XMLContainer.this.getView().removeHierarchyListener(this);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            super.componentHidden(componentEvent);
        }

        public void componentMoved(ComponentEvent componentEvent) {
            super.componentMoved(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            super.componentResized(componentEvent);
            XMLContainer.this.visibleAction(componentEvent.getComponent());
            componentEvent.getComponent().removeComponentListener(this);
        }
    }

    class DisposeJob
    implements Job {
        DisposeJob() {
        }

        public void dispose() {
        }

        public boolean isAlone() {
            return false;
        }

        public void stopIt() {
        }

        public Object getSource() {
            return this;
        }

        public void run() {
            Component component;
            int n;
            if (XMLContainer.this.helperManager != null) {
                XMLContainer.this.helperManager.dispose();
            }
            if (XMLContainer.this.syntaxhelper != null) {
                XMLContainer.this.syntaxhelper.dispose();
            }
            XMLContainer.this.syntaxhelper = null;
            XMLContainer.this.helperManager = null;
            if (XMLContainer.this.tree != null) {
                if (XMLContainer.this.tree.getCellRenderer() instanceof FastTreeRenderer) {
                    ((FastTreeRenderer)XMLContainer.this.tree.getCellRenderer()).dispose();
                }
                XMLContainer.this.treeListeners.dispose();
            }
            if (XMLContainer.this.toolbar != null) {
                for (n = XMLContainer.this.toolbar.getComponentCount() - 1; n >= 0; --n) {
                    component = XMLContainer.this.toolbar.getComponent(n);
                    if (!(component instanceof AbstractButton)) continue;
                    ((AbstractButton)component).setAction(null);
                }
                XMLContainer.this.toolbar.removeAll();
            }
            if (XMLContainer.this.popup != null && !XMLContainer.this.useCustomPopupMenu()) {
                for (n = XMLContainer.this.popup.getComponentCount() - 1; n >= 0; --n) {
                    component = XMLContainer.this.popup.getComponent(n);
                    if (!(component instanceof AbstractButton)) continue;
                    ((AbstractButton)component).setAction(null);
                }
                XMLContainer.this.popup.removeAll();
            }
            if (XMLContainer.this.toolbarModelListener != null) {
                XMLContainer.this.toolBarModel.removeToolBarModelListener(XMLContainer.this.toolbarModelListener);
            }
            if (XMLContainer.this.treeToolBarModelListener != null) {
                XMLContainer.this.treeToolBarModel.removeToolBarModelListener(XMLContainer.this.treeToolBarModelListener);
            }
            if (XMLContainer.this.popupModelListener != null) {
                XMLContainer.this.popupModel.removePopupModelListener(XMLContainer.this.popupModelListener);
            }
            if (XMLContainer.this.treePopupModelListener != null) {
                XMLContainer.this.treePopupModel.removePopupModelListener(XMLContainer.this.treePopupModelListener);
            }
            if (XMLContainer.this.firstEditor != null) {
                JScrollPane jScrollPane = (JScrollPane)XMLContainer.this.firstEditor.getParent().getParent();
                ((ViewRowComponent)jScrollPane.getRowHeader().getView()).dispose();
                jScrollPane.getVerticalScrollBar().removeAdjustmentListener(XMLContainer.this.listenerSP);
                ((XMLDocument)XMLContainer.this.firstEditor.getDocument()).setEditor(null);
                XMLContainer.this.firstEditor.dispose();
                XMLContainer.this.firstEditor.setXMLContainer(null);
                XMLContainer.this.firstEditor = null;
            }
            if (XMLContainer.this.secondEditor != null) {
                JScrollPane jScrollPane = (JScrollPane)XMLContainer.this.secondEditor.getParent().getParent();
                ((ViewRowComponent)jScrollPane.getRowHeader().getView()).dispose();
                jScrollPane.getVerticalScrollBar().removeAdjustmentListener(XMLContainer.this.listenerSP);
                XMLContainer.this.secondEditor.dispose();
                XMLContainer.this.secondEditor.setXMLContainer(null);
                XMLContainer.this.secondEditor = null;
            }
            XMLContainer.this.currentEditor = null;
            if (XMLContainer.this.toolBarModel != null) {
                XMLContainer.this.toolBarModel.dispose();
            }
            if (XMLContainer.this.popupModel != null) {
                XMLContainer.this.popupModel.dispose();
            }
            if (XMLContainer.this.treePopupModel != null) {
                XMLContainer.this.treePopupModel.dispose();
            }
            if (XMLContainer.this.elementView != null) {
                XMLContainer.this.elementView.dispose();
            }
            if (XMLContainer.this.disposeAction) {
                ActionModel.resetActionState(null);
            }
            XMLContainer.this.rootNode = null;
            XMLContainer.this.listenerSP = null;
            if (XMLContainer.this.uiListener != null) {
                XMLContainer.this.uiListener.dispose();
            }
            if (XMLContainer.this.view != null) {
                XMLContainer.this.view.dispose();
            }
            if (XMLContainer.this.errorManager != null) {
                XMLContainer.this.errorManager.dispose();
                XMLContainer.this.errorManager = null;
            }
            if (XMLContainer.this.errorView != null) {
                XMLContainer.this.errorView.dispose();
                XMLContainer.this.errorView = null;
            }
            XMLContainer.this.disposeAccessiblities();
            XMLContainer.this.treeState = null;
            XMLContainer.this.htProperties = null;
            Debug.debug("DISPOSE XMLContainer");
        }
    }
}

