/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.file;

import com.japisoft.xmlpad.action.file.SaveAction;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveAsAction
extends SaveAction {
    public static final String ID = SaveAsAction.class.getName();
    private String currentDir = null;
    private boolean enabledExt = true;

    public void setProperty(String string, Object object) {
        if ("currentDir".equals(string)) {
            this.currentDir = (String)object;
        }
    }

    public Object getProperty(String string, Object object) {
        if ("currentDir".equals(string)) {
            return this.currentDir;
        }
        return super.getProperty(string, object);
    }

    public void setForceExtension(boolean bl) {
        this.enabledExt = bl;
    }

    public boolean notifyAction() {
        if (this.container == null) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (this.currentDir != null) {
            jFileChooser.setCurrentDirectory(new File(this.currentDir));
        }
        jFileChooser.setFileFilter(this.container.getDocumentInfo().getFileFilter());
        if (this.container.getDocumentInfo().getWorkingDirectory() != null) {
            jFileChooser.setCurrentDirectory(new File(this.container.getDocumentInfo().getWorkingDirectory()));
        } else if (this.container.getDocumentInfo().getCurrentDocumentLocation() != null) {
            jFileChooser.setCurrentDirectory(new File(this.container.getDocumentInfo().getCurrentDocumentLocation()).getParentFile());
        }
        int n = jFileChooser.showSaveDialog(this.editor);
        if (n == 0) {
            String string = "" + jFileChooser.getSelectedFile();
            try {
                this.currentDir = jFileChooser.getSelectedFile().getParentFile().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.enabledExt && jFileChooser.getSelectedFile().getName().indexOf(".") == -1) {
                string = string + "." + this.container.getDocumentInfo().getDefaultFileExt();
            }
            try {
                File file;
                if ((this.container.getCurrentDocumentLocation() == null || !this.container.getCurrentDocumentLocation().equals(string)) && (file = new File(string)).exists() && JOptionPane.showConfirmDialog(this.container.getView(), "Overwrite " + string + " ?") != 0) {
                    return false;
                }
                if (this.saveDocument(string)) {
                    this.container.setCurrentDocumentLocation(string);
                    return VALID_ACTION;
                }
                return INVALID_ACTION;
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this.editor, throwable.getMessage(), "Error", 0);
                return INVALID_ACTION;
            }
        }
        return INVALID_ACTION;
    }
}

