/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.xml;

import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FormatAction
extends XMLAction {
    public static final String ID = FormatAction.class.getName();
    public static boolean CANONICAL = false;
    public static boolean DIALOG_ERROR = true;
    public static boolean PRESERVE_EMPTY_ATTRIBUTE_VALUE = true;
    private Integer indentSize = new Integer(4);
    private Character indentChar = new Character(' ');
    private static String PRINTWRITER_ENCODING = "UTF8";
    protected PrintWriter out;
    private boolean ignoreProcessingInstruction = false;
    private boolean replaceLt = true;
    private boolean replaceGt = true;
    private boolean replaceAmp = true;
    private boolean replaceQuote = true;
    private boolean replaceAPos = true;

    public void setProperty(String string, Object object) {
        if ("indent-size".equals(string)) {
            if (object instanceof Integer) {
                this.indentSize = (Integer)object;
            }
        } else if ("indent-char".equals(string)) {
            if (object instanceof Character) {
                this.indentChar = (Character)object;
            } else if (object instanceof String && object.toString().length() > 0) {
                this.indentChar = new Character(object.toString().charAt(0));
            }
        } else {
            super.setProperty(string, object);
        }
    }

    public Object getProperty(String string, Object object) {
        if ("indent-char".equals(string)) {
            return this.indentChar;
        }
        if ("indent-size".equals(string)) {
            return this.indentSize;
        }
        return super.getProperty(string, object);
    }

    public boolean notifyAction() {
        DefaultValidator defaultValidator = new DefaultValidator(true, false);
        if (!defaultValidator.validate(this.container, false)) {
            if (DIALOG_ERROR) {
                JOptionPane.showMessageDialog(this.container.getView(), this.getMessageForError(this.container));
            }
            return XMLAction.INVALID_ACTION;
        }
        Boolean bl = (Boolean)this.container.getProperty("prefAPosEntity");
        if (bl != null) {
            this.setReplaceAPos(bl);
        }
        return this.formatAction(defaultValidator);
    }

    public String getMessageForError(XMLContainer xMLContainer) {
        return XMLContainer.getLocalizedMessage("FORMAT_ERROR", "Can't format with parsing error(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formatAction(DefaultValidator defaultValidator) {
        try {
            if (!defaultValidator.hasError()) {
                if (defaultValidator.getDocument() == null) {
                    boolean bl = INVALID_ACTION;
                    return bl;
                }
                boolean bl = this.formatAction(defaultValidator.getDocument());
                return bl;
            }
            boolean bl = INVALID_ACTION;
            return bl;
        }
        finally {
            defaultValidator.dispose();
        }
    }

    public boolean formatAction(Node node) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.out = new PrintWriter(stringWriter);
            this.ignoreProcessingInstruction = true;
            this.print(node);
            this.out.flush();
            String string = this.editor.getText();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length() && (string.charAt(i) != '<' || i + 1 >= string.length() || string.charAt(i + 1) == '!' || string.charAt(i + 1) == '?'); ++i) {
                stringBuffer.append(string.charAt(i));
                if (string.charAt(i) != '>' || i <= 0 || string.charAt(i - 1) != '?') continue;
                boolean bl = false;
                for (int j = i + 1; j < string.length() && string.charAt(j) != '\n'; ++j) {
                    if (string.charAt(j) != '<') continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                stringBuffer.append("\n");
            }
            this.container.setText(stringBuffer.toString() + stringWriter.toString(), false);
        }
        catch (Throwable throwable) {
            if ("true".equals(System.getProperty("xmlpad.debug"))) {
                throwable.printStackTrace();
            }
            return INVALID_ACTION;
        }
        return VALID_ACTION;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public void print(Node node) {
        this.print(0, node);
    }

    private int getIndentSpace() {
        return this.indentSize;
    }

    public void print(int n, Node node) {
        int n2;
        Object object;
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                object = node.getChildNodes();
                for (n2 = 0; n2 < object.getLength(); ++n2) {
                    if (object.item(n2).getNodeType() == 8) continue;
                    this.print(object.item(n2));
                }
                this.out.flush();
                break;
            }
            case 1: {
                this.ignoreProcessingInstruction = false;
                if (!(node.getParentNode() instanceof Document)) {
                    for (int i = 0; i < n; ++i) {
                        this.out.print(this.indentChar.charValue());
                    }
                }
                this.out.print('<');
                object = node.getPrefix();
                if (object != null && ((String)object).length() > 0) {
                    this.out.print((String)object);
                    this.out.print(':');
                }
                if (node.getLocalName() != null) {
                    this.out.print(node.getLocalName());
                } else {
                    this.out.print(node.getNodeName());
                }
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                String string = null;
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    if (attr.getNodeName().equals(string)) continue;
                    string = attr.getNodeName();
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue(), PRESERVE_EMPTY_ATTRIBUTE_VALUE));
                    this.out.print('\"');
                }
                if (!node.hasChildNodes()) {
                    this.out.print("/>\n");
                } else if (node.getChildNodes().getLength() != 1 || !(node.getChildNodes().item(0) instanceof Text)) {
                    this.out.print(">\n");
                } else {
                    this.out.print(">");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n3 = nodeList.getLength();
                for (int i = 0; i < n3; ++i) {
                    this.print(n + this.getIndentSpace(), nodeList.item(i));
                }
                break;
            }
            case 5: {
                if (bl) {
                    object = node.getChildNodes();
                    if (object == null) break;
                    int n4 = object.getLength();
                    for (int i = 0; i < n4; ++i) {
                        this.print(object.item(i));
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (bl) {
                    this.out.print(this.normalize(node.getNodeValue(), true));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue(), false));
                break;
            }
            case 7: {
                if (this.ignoreProcessingInstruction) break;
                this.out.print("<?");
                this.out.print(node.getNodeName());
                object = node.getNodeValue();
                if (object != null && ((String)object).length() > 0) {
                    this.out.print(' ');
                    this.out.print((String)object);
                }
                this.out.println("?>");
                break;
            }
            case 8: {
                this.out.print("<!--");
                this.out.print(node.getNodeValue());
                this.out.print("-->\n");
            }
        }
        if (s == 1 && node.hasChildNodes()) {
            if (!(node.getParentNode() instanceof Document || (object = node.getChildNodes()).getLength() == 1 && node.getFirstChild() instanceof Text)) {
                for (n2 = 0; n2 < n; ++n2) {
                    this.out.print(this.indentChar.charValue());
                }
            }
            this.out.print("</");
            if (node.getPrefix() != null) {
                this.out.print(node.getPrefix() + ":");
            }
            if (node.getLocalName() != null) {
                this.out.print(node.getLocalName());
            } else {
                this.out.print(node.getNodeName());
            }
            this.out.print(">\n");
        }
        this.out.flush();
    }

    public boolean isReplaceAmp() {
        return this.replaceAmp;
    }

    public void setReplaceAmp(boolean bl) {
        this.replaceAmp = bl;
    }

    public boolean isReplaceAPos() {
        return this.replaceAPos;
    }

    public void setReplaceAPos(boolean bl) {
        this.replaceAPos = bl;
    }

    public boolean isReplaceGt() {
        return this.replaceGt;
    }

    public void setReplaceGt(boolean bl) {
        this.replaceGt = bl;
    }

    public boolean isReplaceLt() {
        return this.replaceLt;
    }

    public void setReplaceLt(boolean bl) {
        this.replaceLt = bl;
    }

    public boolean isReplaceQuote() {
        return this.replaceQuote;
    }

    public void setReplaceQuote(boolean bl) {
        this.replaceQuote = bl;
    }

    protected String normalize(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = CANONICAL;
        boolean bl3 = true;
        boolean bl4 = true;
        int n2 = string != null ? string.length() : 0;
        block8: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\n') {
                bl3 = false;
            }
            bl4 = c == ' ' && bl || c == '\n' ? bl4 : false;
            switch (c) {
                case '<': {
                    if (this.isReplaceLt()) {
                        stringBuffer.append("&lt;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '>': {
                    if (this.isReplaceGt()) {
                        stringBuffer.append("&gt;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '&': {
                    if (n + 4 < n2 && string.charAt(n + 1) == '#' && string.charAt(n + 2) == '1' && string.charAt(n + 3) == '0' && string.charAt(n + 4) == ';') {
                        stringBuffer.append("&#10;");
                        n += 4;
                        continue block8;
                    }
                    if (this.isReplaceAmp()) {
                        stringBuffer.append("&amp;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\"': {
                    if (this.isReplaceQuote()) {
                        stringBuffer.append("&quot;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\'': {
                    if (this.isReplaceAPos()) {
                        stringBuffer.append("&apos;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (bl2) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block8;
                    }
                }
                default: {
                    if (bl4) continue block8;
                    stringBuffer.append(c);
                }
            }
        }
        if (bl3) {
            if (bl) {
                return string;
            }
            return "";
        }
        String string2 = stringBuffer.toString();
        int n3 = -1;
        n = string2.length() - 1;
        while (n >= 0 && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t' || string2.charAt(n) == '\n' || string2.charAt(n) == '\r')) {
            n3 = n--;
        }
        if (n3 != -1) {
            return string2.substring(0, n3);
        }
        return string2;
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(namedNodeMap.item(i));
        }
        Attr[] attrArray = new Attr[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            attrArray[n] = (Attr)arrayList.get(n);
        }
        n2 = attrArray.length;
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }
}

