/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.xmlpad.editor.CommonView;
import com.japisoft.xmlpad.editor.LineElement;
import com.japisoft.xmlpad.editor.LineParsing;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.editor.XMLViewable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;

class WrappedXMLView
extends WrappedPlainView
implements XMLViewable {
    private LineParsing lp;
    private int oldLineIndex = -1;
    private int oldStartUnderlineX1 = -1;
    private int oldStartUnderlineX2 = -1;
    private int oldStartUnderlineY = -1;
    private int oldStopUnderlineX1 = -1;
    private int oldStopUnderlineX2 = -1;
    private int oldStopUnderlineY = -1;
    private String oldElement = "";
    private Segment line = new Segment();

    public WrappedXMLView(Element element) {
        super(element);
        this.lp = new LineParsing();
    }

    public void setDTDMode(boolean bl) {
    }

    public void setSyntaxColor(boolean bl) {
        if (!bl) {
            this.lp = null;
        }
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        this.colorizeLine(n, n2, graphics, n3, n4);
    }

    public int colorizeLine(int n, int n2, Graphics graphics, int n3, int n4) {
        Serializable serializable;
        Document document = this.getDocument();
        XMLEditor xMLEditor = (XMLEditor)this.getContainer();
        Font font = xMLEditor.getFont();
        int n5 = -1;
        int n6 = -1;
        String string = null;
        if (xMLEditor instanceof XMLEditor) {
            serializable = xMLEditor;
            if (serializable.lastStructureLocation != null && !serializable.lastStructureLocation.isClosedLeaf()) {
                n5 = serializable.lastStructureLocation.getStartingOffset();
                n6 = serializable.lastStructureLocation.getStoppingOffset();
                if (serializable.lastStructureLocation.isTag()) {
                    string = serializable.lastStructureLocation.getContent();
                }
            }
        }
        XMLDocument xMLDocument = document instanceof XMLDocument ? (XMLDocument)document : null;
        serializable = graphics.getFontMetrics();
        Color color = this.getDefaultColor();
        Font font2 = xMLEditor.getFont();
        try {
            document.getText(n, n2 - n, this.line);
            int n7 = n;
            int n8 = n2;
            if (this.lp == null) {
                graphics.setColor(color);
                Utilities.drawTabbedText(this.line, n3, n4, graphics, (TabExpander)this, 0);
            } else {
                int n9 = this.getElement().getElementIndex(n);
                int n10 = 0;
                Vector vector = this.lp.parse(this.line, n9);
                for (int i = 0; i < vector.size(); ++i) {
                    int n11;
                    Object object;
                    LineElement lineElement = (LineElement)vector.get(i);
                    String string2 = lineElement.content;
                    int n12 = lineElement.type;
                    Color color2 = LineElement.getColor(xMLEditor, false, false, n12, 0, 0);
                    if (color2 == null) {
                        color2 = color;
                    }
                    if (lineElement.type == 12 && string2 != null && xMLEditor.hasColorForPrefix(string2)) {
                        color2 = xMLEditor.getColorForPrefix(string2);
                    }
                    if (lineElement.type == 5 && string2 != null) {
                        if (xMLEditor.hasColorForTag(string2)) {
                            color2 = xMLEditor.getColorForTag(string2);
                        }
                        if (i >= 2) {
                            object = (LineElement)vector.get(i - 2);
                            if (((LineElement)object).type == 12 && xMLEditor.hasColorForPrefix(((LineElement)object).content)) {
                                color2 = xMLEditor.getColorForPrefix(((LineElement)object).content);
                            }
                        }
                    }
                    if (lineElement.type == 8 && string2 != null && xMLEditor.hasColorForAttribute(string2)) {
                        color2 = xMLEditor.getColorForAttribute(string2);
                    }
                    object = font2;
                    graphics.setColor(color2);
                    this.line.count = n11 = lineElement.content == null ? 0 : lineElement.content.length();
                    int n13 = n3;
                    n3 = Utilities.drawTabbedText(this.line, n3, n4, graphics, (TabExpander)this, n10);
                    int n14 = n10;
                    n10 += this.line.count;
                    if (lineElement.type == 5) {
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (string != null && string.equals(lineElement.content)) {
                            graphics.setColor(xMLEditor.getBackground());
                            graphics.drawLine(this.oldStartUnderlineX1, this.oldStartUnderlineY, this.oldStartUnderlineX2, this.oldStartUnderlineY);
                            graphics.drawLine(this.oldStopUnderlineX1, this.oldStopUnderlineY, this.oldStopUnderlineX2, this.oldStopUnderlineY);
                            bl3 = true;
                        } else {
                            bl2 = true;
                        }
                        if (bl3 && n5 > -1 && n7 + n14 >= n5 && n7 + n14 <= n5 + this.line.count) {
                            if (bl2) {
                                this.oldStartUnderlineX1 = n13;
                                this.oldStartUnderlineX2 = n3;
                                this.oldStartUnderlineY = n4 + 2;
                            }
                            this.drawUnderline(n13, n3, n4 + 2, LineElement.getColor(xMLEditor, false, false, 13, 0, 0), graphics);
                            bl = true;
                        }
                        if (bl3 && !bl && n6 > -1 && n7 + n10 >= n6 - this.line.count && n7 + n10 <= n6) {
                            if (bl2) {
                                this.oldStopUnderlineX1 = n13;
                                this.oldStopUnderlineX2 = n3;
                                this.oldStopUnderlineY = n4 + 2;
                            }
                            this.drawUnderline(n13, n3, n4 + 2, LineElement.getColor(xMLEditor, false, false, 13, 0, 0), graphics);
                        }
                    }
                    this.line.offset += this.line.count;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n3;
    }

    private void drawUnderline(int n, int n2, int n3, Color color, Graphics graphics) {
        graphics.setColor(LineElement.getColor((XMLEditor)this.getContainer(), false, false, 13, 0, 0));
        int n4 = n3;
        for (int i = n; i <= n2; i += 2) {
            graphics.drawLine(i, n4, i, n4);
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }

    static {
        CommonView.class.getName();
    }
}

