/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper;

import com.japisoft.dtdparser.DTDMapper;
import com.japisoft.dtdparser.DTDMapperFactory;
import com.japisoft.dtdparser.DTDParser;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.job.KnownJob;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.error.ErrorListener;
import com.japisoft.xmlpad.error.ErrorManager;
import com.japisoft.xmlpad.helper.HelperManager;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.handler.relaxng.RelaxNGTagHelperHandler;
import com.japisoft.xmlpad.helper.handler.schema.AbstractEntityHandler;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.handler.schema.AttributeHandler;
import com.japisoft.xmlpad.helper.handler.schema.AttributeValueHandler;
import com.japisoft.xmlpad.helper.handler.schema.dtd.DTDEntityHandler;
import com.japisoft.xmlpad.helper.handler.schema.dtd.DTDTagHandler;
import com.japisoft.xmlpad.helper.handler.schema.w3c.W3cTagHandler;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import com.japisoft.xmlpad.toolkit.XMLFileData;
import com.japisoft.xmlpad.toolkit.XMLToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.xml.sax.EntityResolver;

public class SchemaHelperManager
implements ErrorListener {
    private ErrorManager errorManager;
    private HelperManager helperManager;
    private boolean hasError = false;
    private String forcePrefix = null;
    private String defaultNamespace = null;
    private String externalDTDCommentFile = null;

    public SchemaHelperManager(ErrorManager errorManager, HelperManager helperManager) {
        this.errorManager = errorManager;
        this.helperManager = helperManager;
    }

    public void initErrorProcessing() {
        this.hasError = false;
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        this.hasError = true;
    }

    public void notifyNoError(boolean bl) {
        this.hasError = false;
    }

    public void stopErrorProcessing() {
        this.helperManager.setEnabled("schema-elements", !this.hasError);
        this.helperManager.setEnabled("schema-attributes", !this.hasError);
        this.helperManager.setEnabled("schema-attribute-values", !this.hasError);
    }

    public void dispose() {
        this.uninstallSchemaHandlers();
        this.errorManager = null;
        this.helperManager = null;
    }

    private void uninstallSchemaHandlers() {
        if (this.helperManager == null) {
            return;
        }
        this.helperManager.removeHelperHandler("schema-elements");
        this.helperManager.removeHelperHandler("schema-attributes");
        this.helperManager.removeHelperHandler("schema-attribute-values");
        this.helperManager.removeHelperHandler("schema-entities");
    }

    private AbstractHelperHandler[] installTagHelperHandler(AbstractTagHandler abstractTagHandler) {
        if (this.helperManager == null) {
            return new AbstractHelperHandler[0];
        }
        this.helperManager.addHelperHandler(abstractTagHandler);
        AttributeHandler attributeHandler = new AttributeHandler(abstractTagHandler);
        this.helperManager.addHelperHandler(attributeHandler);
        AttributeValueHandler attributeValueHandler = new AttributeValueHandler(abstractTagHandler);
        this.helperManager.addHelperHandler(attributeValueHandler);
        return new AbstractHelperHandler[]{abstractTagHandler, attributeHandler, attributeValueHandler};
    }

    private void installEntitiesHandler(AbstractEntityHandler abstractEntityHandler) {
        this.helperManager.addHelperHandler(abstractEntityHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelaxNGLocation(SchemaLocator schemaLocator) {
        this.uninstallSchemaHandlers();
        if (schemaLocator == null) {
            return;
        }
        Parser parser = new Parser();
        Reader reader = null;
        try {
            reader = schemaLocator.getReader();
            parser.setReader(reader);
            try {
                parser.parse();
                Document document = parser.getDocument();
                this.installTagHelperHandler(new RelaxNGTagHelperHandler((SimpleNode)document.getRoot()));
            }
            finally {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            this.errorManager.notifyUniqueError(true, null, 0, 0, 0, "Can't load the RelaxNG Schema", false);
        }
    }

    public void setSchemaLocation(String string, String[] stringArray, String[] stringArray2, String string2, int n, EntityResolver entityResolver) {
        this.uninstallSchemaHandlers();
        if (stringArray2 == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray2.length; ++i) {
            Object object;
            String string3 = stringArray2[i];
            try {
                if (entityResolver == null) {
                    entityResolver = SharedProperties.DEFAULT_ENTITY_RESOLVER;
                }
                SchemaLocator schemaLocator = new SchemaLocator(string, string3, entityResolver);
                object = XMLToolkit.getContentFromInputStream(schemaLocator.getInputStream(), null);
                Parser parser = new Parser();
                parser.setContent(((XMLFileData)object).getContent().toCharArray());
                parser.parse();
                Document document = parser.getDocument();
                this.installTagHelperHandler(new W3cTagHandler(string2, (SimpleNode)document.getRoot(), schemaLocator.getSource()));
                continue;
            }
            catch (Throwable throwable) {
                object = "?";
                if (stringArray2 != null && stringArray2.length > 0) {
                    object = stringArray2[0];
                }
                this.errorManager.notifyUniqueError(true, null, 0, 0, 0, "Can't load the W3C XML Schema " + (String)object, false);
            }
        }
    }

    public void setDTDContent(String string, String string2, int n) {
        StringReader stringReader = new StringReader(string2);
        SchemaLocator schemaLocator = new SchemaLocator(stringReader);
        schemaLocator.schemaDeclarationLine = n;
        this.setDTD(string, schemaLocator);
    }

    public void setDTDContent(String string, SchemaLocator schemaLocator) {
        this.setDTD(string, schemaLocator);
    }

    public void setDTDLocation(String string, String string2, String string3, int n) {
        this.uninstallSchemaHandlers();
        if (string2 == null) {
            return;
        }
        try {
            if (DTDMapperFactory.getDTDMapper() != null) {
                InputStream inputStream = DTDMapperFactory.getDTDMapper().getStream(string2);
                if (inputStream == null) {
                    SchemaLocator schemaLocator = new SchemaLocator(string, string2);
                    schemaLocator.schemaDeclarationLine = n;
                    this.setDTD(string3, schemaLocator);
                } else {
                    SchemaLocator schemaLocator = new SchemaLocator(inputStream, string2);
                    schemaLocator.schemaDeclarationLine = n;
                    this.setDTD(string3, schemaLocator);
                }
            } else {
                SchemaLocator schemaLocator = new SchemaLocator(string, string2);
                schemaLocator.schemaDeclarationLine = n;
                this.setDTD(string3, schemaLocator);
            }
        }
        catch (Throwable throwable) {
            Debug.debug(throwable);
            this.errorManager.notifyUniqueError(true, null, 0, 0, 0, "Can't load the DTD " + string2, false);
        }
    }

    private void setDTD(String string, SchemaLocator schemaLocator) {
        String string2 = schemaLocator.getSource();
        if (schemaLocator != null) {
            try {
                JobManager.addJob(new DTDParsingJob(string, schemaLocator));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setForcePrefix(String string) {
        this.forcePrefix = string;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public void setExternalDTDCommentFile(String string) {
        this.externalDTDCommentFile = string;
    }

    class DTDParsingJob
    implements KnownJob {
        private String rootElement = null;
        private SchemaLocator input = null;

        public DTDParsingJob(String string, SchemaLocator schemaLocator) {
            this.rootElement = string;
            this.input = schemaLocator;
        }

        public Object getSource() {
            return SchemaHelperManager.this;
        }

        public void dispose() {
            this.rootElement = null;
            this.input = null;
        }

        public boolean isAlone() {
            return false;
        }

        public String getErrorMessage() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    DTDMapper dTDMapper;
                    DTDParser dTDParser = new DTDParser();
                    boolean bl = false;
                    if (SchemaHelperManager.this.externalDTDCommentFile != null) {
                        try {
                            dTDParser.parseExternalDTDComment(new URL(SchemaHelperManager.this.externalDTDCommentFile));
                        }
                        catch (MalformedURLException malformedURLException) {
                            Debug.debug(malformedURLException);
                        }
                        catch (RuntimeException runtimeException) {
                            Debug.debug(runtimeException);
                        }
                    }
                    if (this.input.documentLocation != null && !this.input.streamProvided() && (dTDMapper = DTDMapperFactory.getDTDMapper()) != null) {
                        try {
                            InputStream inputStream = dTDMapper.getStream(this.input.location);
                            if (inputStream != null) {
                                bl = true;
                                dTDParser.parse(inputStream);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl) {
                        dTDParser.parse(this.input);
                    }
                    if (this.rootElement == null) {
                        this.rootElement = dTDParser.getDTDDocumentBuilder().getFirstElement();
                    }
                    SchemaHelperManager.this.uninstallSchemaHandlers();
                    SchemaHelperManager.this.installTagHelperHandler(new DTDTagHandler(this.rootElement, dTDParser.getDTDElement()));
                    SchemaHelperManager.this.installEntitiesHandler(new DTDEntityHandler(dTDParser.getDTDElement()));
                }
                catch (Throwable throwable) {
                    Debug.debug(throwable);
                    SchemaHelperManager.this.errorManager.notifyUniqueError(true, null, 0, 0, 0, "Can't load the DTD " + this.input.getSource(), false);
                }
            }
            finally {
                this.rootElement = null;
                this.input = null;
            }
        }

        public void stopIt() {
        }

        public String getName() {
            return "DTD Parsing";
        }
    }
}

