/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.schema;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import com.japisoft.xmlpad.helper.model.AttValueDescriptor;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import javax.swing.text.BadLocationException;

public class AttributeValueHandler
extends AbstractHelperHandler {
    private AbstractTagHandler tagHandler;

    public AttributeValueHandler(AbstractTagHandler abstractTagHandler) {
        this.tagHandler = abstractTagHandler;
    }

    public void dispose() {
        super.dispose();
        this.tagHandler = null;
    }

    public String getTitle() {
        return this.tagHandler.getTitle();
    }

    public int getPriority() {
        return 1;
    }

    protected String getActivatorSequence() {
        return "\"";
    }

    public String getName() {
        return "schema-attribute-values";
    }

    public boolean haveDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, boolean bl, int n, String string) {
        if (("\"".equals(string) || "'".equals(string)) && xMLDocument.isInsideTag(n, true, true)) {
            return true;
        }
        return string == null && xMLDocument.isInsideAttributeValue(n);
    }

    protected void installDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, int n, String string) {
        if (simpleNode == null) {
            return;
        }
        TagDescriptor tagDescriptor = this.tagHandler.getTag(simpleNode);
        if (tagDescriptor == null) {
            return;
        }
        AttDescriptor[] attDescriptorArray = tagDescriptor.getAtts();
        if (attDescriptorArray != null) {
            String string2 = xMLDocument.getForwardAttributeName(xMLDocument, n);
            if (string2 == null) {
                return;
            }
            for (int i = 0; i < attDescriptorArray.length; ++i) {
                AttDescriptor attDescriptor = attDescriptorArray[i];
                if (!attDescriptor.getName().equals(string2)) continue;
                String[] stringArray = attDescriptor.getEnumValues();
                if (stringArray == null) break;
                for (int j = 0; j < stringArray.length; ++j) {
                    AttValueDescriptor attValueDescriptor = new AttValueDescriptor(stringArray[j], string != null ? string.charAt(0) : (char)'\"');
                    attValueDescriptor.setAddedPart(string);
                    attValueDescriptor.setSource(this);
                    this.addDescriptor(attValueDescriptor);
                }
                break;
            }
        }
    }

    public boolean hasDelegateForInsertingResult() {
        return true;
    }

    public void insertResult(XMLDocument xMLDocument, int n, String string) {
        int[] nArray = xMLDocument.getAttributeValueLocation(n);
        if (nArray == null) {
            xMLDocument.insertStringWithoutHelper(n, string, null);
        } else {
            try {
                xMLDocument.replace(nArray[0], nArray[1] - nArray[0] + 1, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

