/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.schema.w3c;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AndCriteria;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.OrCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.SchemaNodeProducer;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class SchemaToSchemaNode
implements SchemaNodeProducer {
    private Hashtable htPrefixNamespaces = new Hashtable();
    public boolean allattributeMode = false;

    public SchemaNode getSchemaNode(Object object) {
        SimpleNode simpleNode = (SimpleNode)object;
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.getDocument().getRoot();
        SchemaNode schemaNode = new SchemaNode(2);
        schemaNode.namespace = simpleNode2.getAttribute("targetNamespace");
        for (int i = 0; i < simpleNode2.getViewAttributeCount(); ++i) {
            String string = simpleNode2.getViewAttributeAt(i);
            if (!string.startsWith("xmlns:")) continue;
            String string2 = simpleNode2.getViewAttribute(string);
            String string3 = string.substring(7);
            this.htPrefixNamespaces.put(string3, string2);
        }
        this.processElement(simpleNode, schemaNode, false);
        return schemaNode;
    }

    public void processElement(SimpleNode simpleNode, SchemaNode schemaNode, boolean bl) {
        String string = simpleNode.getAttribute("name");
        if (string == null) {
            string = simpleNode.getAttribute("ref");
        }
        if (string != null) {
            int n = 0;
            n = string.indexOf(":");
            if (n > -1) {
                try {
                    string = string.substring(n + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        schemaNode.element = new TagDescriptor(string, true);
        schemaNode.element.setComment(this.getAnnotation(simpleNode));
        SimpleNode simpleNode2 = this.getElementDefinition(simpleNode);
        if (simpleNode2 != null) {
            this.processType(simpleNode2, schemaNode, bl);
        } else {
            schemaNode.element.empty = false;
        }
        if (bl && string != null) {
            TreeWalker treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
            Enumeration enumeration = treeWalker.getNodeByCriteria(new AndCriteria(new NodeNameCriteria("element"), new AttributeCriteria("substitutionGroup", string, true)), false);
            while (enumeration.hasMoreElements()) {
                SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
                if (simpleNode3 == simpleNode) continue;
                SchemaNode schemaNode2 = new SchemaNode(0);
                this.processElement(simpleNode3, schemaNode2, bl);
                schemaNode.element.addSynonymousTagDescriptor(schemaNode2.element);
            }
        }
    }

    private void processType(SimpleNode simpleNode, SchemaNode schemaNode, boolean bl) {
        if (simpleNode.matchContent("complexType")) {
            if ("true".equals(simpleNode.getAttribute("mixed")) && schemaNode.isElement()) {
                schemaNode.element.empty = false;
            }
            this.processComplexType(simpleNode, schemaNode, bl);
        } else if (simpleNode.matchContent("simpleType") && schemaNode.isElement()) {
            schemaNode.element.empty = false;
        }
    }

    private void processComplexType(SimpleNode simpleNode, SchemaNode schemaNode, boolean bl) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (simpleNode2.matchContent("complexContent") || simpleNode2.matchContent("simpleContent") || simpleNode2.matchContent("restriction") || simpleNode2.matchContent("extension")) {
                this.processComplexType(simpleNode2, schemaNode, bl);
                continue;
            }
            if (simpleNode2.matchContent("attribute")) {
                this.processAttribute(simpleNode2, schemaNode);
                continue;
            }
            if (simpleNode2.matchContent("attributeGroup")) {
                this.processAttributeGroup(simpleNode2, schemaNode);
                continue;
            }
            if (simpleNode2.matchContent("group")) {
                schemaNode.element.empty = false;
                if (bl) continue;
                this.processGroup(simpleNode, schemaNode);
                continue;
            }
            if (simpleNode2.matchContent("all")) {
                schemaNode.element.empty = false;
                if (bl) continue;
                this.processAll(simpleNode2, schemaNode);
                continue;
            }
            if (simpleNode2.matchContent("choice")) {
                schemaNode.element.empty = false;
                if (bl) continue;
                this.processChoice(simpleNode2, schemaNode);
                continue;
            }
            if (!simpleNode2.matchContent("sequence")) continue;
            schemaNode.element.empty = false;
            if (bl) continue;
            this.processSequence(simpleNode2, schemaNode);
        }
    }

    private void processGroup(SimpleNode simpleNode, SchemaNode schemaNode) {
        TreeWalker treeWalker;
        SimpleNode simpleNode2;
        String string = simpleNode.getAttribute("ref");
        if (string != null && (simpleNode2 = (treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot())).getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("group"), new OrCriteria(new AttributeCriteria("name", string, true), new AttributeCriteria("id", string))), false)) != null) {
            simpleNode = simpleNode2;
        }
        this.processComplexType(simpleNode, schemaNode, false);
    }

    private void processAttribute(SimpleNode simpleNode, SchemaNode schemaNode) {
        String string = simpleNode.getAttribute("ref");
        boolean bl = "required".equals(simpleNode.getAttribute("use"));
        AttDescriptor attDescriptor = null;
        SimpleNode simpleNode2 = simpleNode;
        if (bl || this.allattributeMode) {
            if (string != null) {
                TreeWalker treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
                SimpleNode simpleNode3 = treeWalker.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("attribute"), new AttributeCriteria("name", string)), false);
                if (simpleNode3 != null) {
                    simpleNode2 = simpleNode3;
                    attDescriptor = this.getDescriptorForNode(simpleNode3);
                    schemaNode.element.addAttDescriptor(attDescriptor);
                }
            } else {
                attDescriptor = this.getDescriptorForNode(simpleNode);
                schemaNode.element.addAttDescriptor(attDescriptor);
            }
        }
        if (attDescriptor != null) {
            this.prepareEnumValuesForAttributeNode(simpleNode2, attDescriptor);
        }
    }

    private String getAnnotation(SimpleNode simpleNode) {
        if (!simpleNode.isLeaf()) {
            SimpleNode simpleNode2 = simpleNode.childAt(0);
            if (simpleNode2.matchContent("annotation")) {
                if (!simpleNode2.isLeaf()) {
                    StringBuffer stringBuffer = null;
                    for (int i = 0; i < simpleNode2.childCount(); ++i) {
                        SimpleNode simpleNode3 = simpleNode2.childAt(i);
                        if (!simpleNode3.matchContent("documentation")) continue;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        if (simpleNode3.isLeaf()) continue;
                        stringBuffer.append(simpleNode3.childAt(i));
                    }
                    if (stringBuffer != null) {
                        return stringBuffer.toString();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private AttDescriptor getDescriptorForNode(SimpleNode simpleNode) {
        boolean bl = "required".equals(simpleNode.getAttribute("use"));
        String string = simpleNode.getAttribute("default");
        AttDescriptor attDescriptor = new AttDescriptor(simpleNode.getAttribute("name"), string, bl);
        attDescriptor.setComment(this.getAnnotation(simpleNode));
        return attDescriptor;
    }

    String f(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    private void prepareEnumValuesForAttributeNode(SimpleNode simpleNode, AttDescriptor attDescriptor) {
        TreeWalker treeWalker;
        Enumeration enumeration;
        String string = simpleNode.getAttribute("type");
        if (string != null && string.indexOf(":") > -1) {
            if (string.endsWith("boolean")) {
                attDescriptor.addEnumValue("false");
                attDescriptor.addEnumValue("true");
            } else {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
                String string2 = this.f(gregorianCalendar.get(2));
                String string3 = this.f(gregorianCalendar.get(5));
                String string4 = this.f(gregorianCalendar.get(10));
                String string5 = this.f(gregorianCalendar.get(12));
                String string6 = this.f(gregorianCalendar.get(13));
                if (string.endsWith("dateTime")) {
                    String string7 = gregorianCalendar.get(1) + "-" + string2 + "-" + string3 + "T" + string4 + ":" + string5 + ":" + string6;
                    attDescriptor.addEnumValue(string7);
                    for (int i = -12; i < 12; ++i) {
                        int n = Math.abs(i);
                        String string8 = n < 10 ? "0" + n : "" + n;
                        string8 = i < 0 ? "-" + string8 : "+" + string8;
                        attDescriptor.addEnumValue(string7 + string8 + ":00");
                    }
                } else if (string.endsWith("time")) {
                    String string9 = string4 + ":" + string5 + ":" + string6;
                    attDescriptor.addEnumValue(string9);
                    for (int i = -12; i < 12; ++i) {
                        int n = Math.abs(i);
                        String string10 = n < 10 ? "0" + n : "" + n;
                        string10 = i < 0 ? "-" + string10 : "+" + string10;
                        attDescriptor.addEnumValue(string9 + string10 + ":00");
                    }
                } else if (string.endsWith("date")) {
                    String string11 = gregorianCalendar.get(1) + "-" + string2 + "-" + string3;
                    attDescriptor.addEnumValue(string11);
                    for (int i = -12; i < 12; ++i) {
                        int n = Math.abs(i);
                        String string12 = n < 10 ? "0" + n : "" + n;
                        string12 = i < 0 ? "-" + string12 : "+" + string12;
                        attDescriptor.addEnumValue(string11 + string12 + ":00");
                    }
                } else if (string.endsWith("gYearMonth")) {
                    String string13 = gregorianCalendar.get(1) + "-" + string2;
                    attDescriptor.addEnumValue(string13);
                } else if (string.endsWith("gYear")) {
                    String string14 = gregorianCalendar.get(1) + "";
                    attDescriptor.addEnumValue(string14);
                } else if (string.endsWith("gMonthDay")) {
                    String string15 = "--" + string2 + "-" + string3;
                    attDescriptor.addEnumValue(string15);
                } else if (string.endsWith("gDay")) {
                    String string16 = "---" + string3 + "";
                    attDescriptor.addEnumValue(string16);
                } else if (string.endsWith("gMonth")) {
                    String string17 = string2 + "";
                    attDescriptor.addEnumValue(string17);
                }
            }
            return;
        }
        SimpleNode simpleNode2 = null;
        if (simpleNode.childCount() > 0) {
            if (simpleNode.childAt(0).matchContent("simpleType")) {
                simpleNode2 = simpleNode.childAt(0);
            }
        } else if (string != null && (enumeration = (treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot())).getNodeByCriteria(new AndCriteria(new NodeNameCriteria("simpleType"), new AttributeCriteria("name", string)), false)).hasMoreElements()) {
            simpleNode2 = (SimpleNode)enumeration.nextElement();
        }
        if (simpleNode2 != null) {
            treeWalker = new TreeWalker(simpleNode2);
            enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("enumeration"), true);
            while (enumeration.hasMoreElements()) {
                SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
                attDescriptor.addEnumValue(simpleNode3.getAttribute("value"));
            }
        }
    }

    private void processAttributeGroup(SimpleNode simpleNode, SchemaNode schemaNode) {
        String string = simpleNode.getAttribute("ref");
        if (string != null) {
            TreeWalker treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
            SimpleNode simpleNode2 = treeWalker.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("attributeGroup"), new OrCriteria(new AttributeCriteria("name", string, true), new AttributeCriteria("id", string))), false);
            if (simpleNode2 != null) {
                this.processAttributeGroup(simpleNode2, schemaNode);
            }
        } else {
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                SimpleNode simpleNode3 = simpleNode.childAt(i);
                if (simpleNode3.matchContent("attribute")) {
                    this.processAttribute(simpleNode3, schemaNode);
                    continue;
                }
                if (!simpleNode3.matchContent("attributeGroup")) continue;
                this.processAttributeGroup(simpleNode3, schemaNode);
            }
        }
    }

    private void processAll(SimpleNode simpleNode, SchemaNode schemaNode) {
        this.processSequence(simpleNode, schemaNode);
    }

    private SchemaNode commonProcessChoiceSequence(SimpleNode simpleNode, TagDescriptor tagDescriptor) {
        SchemaNode schemaNode = null;
        if (simpleNode.matchContent("element")) {
            schemaNode = new SchemaNode(0);
            this.processElement(simpleNode, schemaNode, true);
        } else if (simpleNode.matchContent("group")) {
            schemaNode = new SchemaNode(2);
            schemaNode.element = tagDescriptor;
            this.processGroup(simpleNode, schemaNode);
        } else if (simpleNode.matchContent("choice")) {
            schemaNode = new SchemaNode(2);
            schemaNode.element = tagDescriptor;
            this.processChoice(simpleNode, schemaNode);
        } else if (simpleNode.matchContent("sequence")) {
            schemaNode = new SchemaNode(2);
            schemaNode.element = tagDescriptor;
            this.processSequence(simpleNode, schemaNode);
        } else if (simpleNode.matchContent("any")) {
            // empty if block
        }
        return schemaNode;
    }

    private void processChoice(SimpleNode simpleNode, SchemaNode schemaNode) {
        SchemaNode schemaNode2 = new SchemaNode(3);
        int n = this.getMinOccurs(simpleNode);
        int n2 = this.getMaxOccurs(simpleNode);
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            SchemaNode schemaNode3 = this.commonProcessChoiceSequence(simpleNode2, schemaNode.element);
            int n3 = this.getMinOccurs(simpleNode2);
            int n4 = this.getMaxOccurs(simpleNode2);
            if (schemaNode3 == null) continue;
            SchemaNode schemaNode4 = schemaNode2;
            if (n3 == 0) {
                schemaNode4 = new SchemaNode(3);
                schemaNode2.addNext(schemaNode4);
                schemaNode4.addNext(new SchemaNode(1));
                continue;
            }
            if (n4 == 1) {
                schemaNode2.addNext(schemaNode3);
                continue;
            }
            if (n4 <= 1) continue;
            SchemaNode schemaNode5 = new SchemaNode(4);
            schemaNode2.addNext(schemaNode5);
            if (n4 == Integer.MAX_VALUE) {
                schemaNode5.addNext(schemaNode3);
                schemaNode3.addNext(schemaNode3);
                continue;
            }
            SchemaNode schemaNode6 = (SchemaNode)schemaNode3.clone();
            for (int j = 1; j <= n4; ++j) {
                schemaNode5.addNext(schemaNode6);
            }
        }
        if (schemaNode2.getSchemaNodeCount() > 0) {
            schemaNode.addNext(schemaNode2);
        }
        if (n2 == Integer.MAX_VALUE) {
            schemaNode2.addNext(schemaNode2);
        } else {
            SchemaNode schemaNode7 = (SchemaNode)schemaNode2.clone();
            for (int i = 0; i < n2 - 1; ++i) {
                schemaNode2.addNext(schemaNode7);
            }
        }
    }

    private void processSequence(SimpleNode simpleNode, SchemaNode schemaNode) {
        SchemaNode schemaNode2 = new SchemaNode(4);
        int n = this.getMinOccurs(simpleNode);
        int n2 = this.getMaxOccurs(simpleNode);
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            SchemaNode schemaNode3 = this.commonProcessChoiceSequence(simpleNode2, schemaNode.element);
            int n3 = this.getMinOccurs(simpleNode2);
            int n4 = this.getMaxOccurs(simpleNode2);
            if (schemaNode3 == null) continue;
            SchemaNode schemaNode4 = schemaNode2;
            if (n3 == 0) {
                schemaNode4 = new SchemaNode(3);
                schemaNode2.addNext(schemaNode4);
                schemaNode4.addNext(new SchemaNode(1));
            }
            if (n4 == Integer.MAX_VALUE) {
                schemaNode4.addNext(schemaNode3);
                schemaNode3.addNext(schemaNode3);
                continue;
            }
            for (int j = 1; j <= n4; ++j) {
                if (schemaNode3.isElement()) {
                    schemaNode4.addNext(schemaNode3);
                    continue;
                }
                for (int k = 0; k < schemaNode3.getSchemaNodeCount(); ++k) {
                    schemaNode4.addNext(schemaNode3.getSchemaNode(k));
                }
            }
        }
        if (schemaNode2.getSchemaNodeCount() > 0) {
            schemaNode.addNext(schemaNode2);
        }
        if (n2 == Integer.MAX_VALUE) {
            schemaNode2.addNext(schemaNode2);
        } else {
            SchemaNode schemaNode5 = (SchemaNode)schemaNode2.clone();
            for (int i = 0; i < n2 - 1; ++i) {
                schemaNode2.addNext(schemaNode5);
            }
        }
    }

    private SimpleNode getFirstChildWithoutAnnotation(SimpleNode simpleNode) {
        if (simpleNode.childCount() > 0) {
            SimpleNode simpleNode2 = simpleNode.childAt(0);
            if (simpleNode2.matchContent("annotation")) {
                if (simpleNode.childCount() > 1) {
                    return simpleNode.childAt(1);
                }
                return null;
            }
            return simpleNode2;
        }
        return null;
    }

    private SimpleNode getElementDefinition(SimpleNode simpleNode) {
        TreeWalker treeWalker;
        SimpleNode simpleNode2;
        String string = simpleNode.getAttribute("type");
        if (string != null) {
            int n = 0;
            String string2 = null;
            n = string.indexOf(":");
            if (n > -1) {
                string2 = string.substring(n + 1);
            }
            TreeWalker treeWalker2 = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
            SimpleNode simpleNode3 = treeWalker2.getOneNodeByCriteria(new AndCriteria(new OrCriteria(new NodeNameCriteria("complexType"), new NodeNameCriteria("simpleType")), new OrCriteria(new AttributeCriteria("name", string), string2 != null ? new AttributeCriteria("name", string2) : null)), false);
            return simpleNode3;
        }
        String string3 = simpleNode.getAttribute("ref");
        if (string3 != null) {
            TreeWalker treeWalker3 = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
            SimpleNode simpleNode4 = treeWalker3.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("element"), new AttributeCriteria("name", string3, true)), false);
            if (simpleNode4 != null) {
                return this.getElementDefinition(simpleNode4);
            }
            return null;
        }
        String string4 = simpleNode.getAttribute("substitutionGroup");
        if (string4 != null && (simpleNode2 = (treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot())).getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("element"), new AttributeCriteria("name", string4, true)), false)) != null) {
            return this.getElementDefinition(simpleNode2);
        }
        return this.getFirstChildWithoutAnnotation(simpleNode);
    }

    private int getMinOccurs(SimpleNode simpleNode) {
        String string = simpleNode.getAttribute("minOccurs");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private int getMaxOccurs(SimpleNode simpleNode) {
        String string = simpleNode.getAttribute("maxOccurs");
        if ("unbounded".equals(string)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }
}

