/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.xml.validator;

import com.japisoft.dtdparser.DTDMapper;
import com.japisoft.dtdparser.DTDMapperFactory;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.xml.validator.Validator;
import com.japisoft.xmlpad.xml.validator.XMLPadSAXParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.Element;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class DefaultValidator
implements Validator,
ErrorHandler {
    private XMLEditor editor;
    private boolean domBuilderMode = false;
    private Document dom = null;
    private boolean tryToValidate = true;
    private boolean errorStatus = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(XMLContainer xMLContainer, boolean bl) {
        this.editor = xMLContainer.getEditor();
        boolean bl2 = true;
        try {
            bl2 = this.canValidate(xMLContainer) ? this.notifyAction(xMLContainer, bl) : false;
        }
        finally {
            this.editor = null;
        }
        return bl2;
    }

    protected boolean canValidate(XMLContainer xMLContainer) {
        return true;
    }

    private boolean checkLocation(String string) {
        if (string.indexOf("://") == -1 && DTDMapperFactory.getDTDMapper() == null) {
            File file = new File(string);
            return file.exists();
        }
        return true;
    }

    public void setDomBuilderMode(boolean bl) {
        this.domBuilderMode = bl;
    }

    public DefaultValidator() {
    }

    public DefaultValidator(boolean bl) {
        this();
        this.domBuilderMode = bl;
    }

    public DefaultValidator(boolean bl, boolean bl2) {
        this();
        this.domBuilderMode = bl;
        this.tryToValidate = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyAction(XMLContainer xMLContainer, boolean bl) {
        try {
            boolean bl2;
            this.errorStatus = false;
            Object var3_3 = null;
            boolean bl4 = false;
            InputSource inputSource = null;
            StringReader stringReader = null;
            String string = xMLContainer.getText();
            if (this.domBuilderMode) {
                string = string.replaceAll("&#10;", "&amp;#10;");
            }
            stringReader = new StringReader(string);
            inputSource = new InputSource(stringReader);
            if (xMLContainer.getCurrentDocumentLocation() != null) {
                inputSource.setSystemId(new File(xMLContainer.getCurrentDocumentLocation()).toURL().toString());
            }
            boolean bl3 = false;
            boolean bl6 = false;
            boolean bl5 = bl2 = SharedProperties.DEFAULT_ENTITY_RESOLVER != null;
            if (this.tryToValidate) {
                try {
                    String string2;
                    bl3 = xMLContainer.searchAndParseSchema();
                    if (bl3) {
                        string2 = xMLContainer.getSchemaAccessibility().getSchemaLocation(true);
                        if (!xMLContainer.hasSyntaxCompletion() && !this.checkLocation(string2)) {
                            this.errorStatus = true;
                            return false;
                        }
                        bl4 = true;
                    }
                    if (!bl3 && (bl6 = xMLContainer.searchAndParseDTD())) {
                        string2 = xMLContainer.getSchemaAccessibility().getDTDLocation(true);
                        if (string2 != null && !xMLContainer.hasSyntaxCompletion() && !this.checkLocation(string2)) {
                            this.errorStatus = true;
                            return false;
                        }
                        bl4 = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                block40: {
                    boolean bl8;
                    block37: {
                        Object object;
                        block39: {
                            EntityResolver entityResolver;
                            block38: {
                                if (xMLContainer.getErrorManager().hasLastError()) {
                                    boolean bl52 = false;
                                    return bl52;
                                }
                                boolean bl7 = bl8 = xMLContainer.getDocumentInfo().getSchemaXSDValid() != null;
                                if (bl8) {
                                    bl4 = true;
                                }
                                if (this.domBuilderMode) break block37;
                                Object object2 = XMLPadSAXParserFactory.getNewSAXParser(bl4);
                                Debug.debug("Parser=" + object2);
                                if (bl3 || bl8) {
                                    try {
                                        ((SAXParser)object2).setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                                    }
                                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                                        // empty catch block
                                    }
                                }
                                if (bl8 && (object = this.buildCustomParser(xMLContainer)) != null) {
                                    object2 = object;
                                }
                                object = ((SAXParser)object2).getXMLReader();
                                object.setErrorHandler(this);
                                entityResolver = (EntityResolver)xMLContainer.getProperty("entityresolver");
                                if (entityResolver != null) break block38;
                                if (bl2) {
                                    object.setEntityResolver(SharedProperties.DEFAULT_ENTITY_RESOLVER);
                                    break block39;
                                } else if (DTDMapperFactory.getDTDMapper() != null) {
                                    object.setEntityResolver(new CustomEntityResolver());
                                }
                                break block39;
                            }
                            object.setEntityResolver(entityResolver);
                        }
                        object.parse(inputSource);
                        break block40;
                    }
                    if (bl8) {
                        bl4 = false;
                    }
                    DocumentBuilder documentBuilder = XMLPadSAXParserFactory.getNewDocumentBuilder(bl4, bl3);
                    Debug.debug("builder : " + documentBuilder);
                    documentBuilder.setErrorHandler(this);
                    if (bl2) {
                        documentBuilder.setEntityResolver(SharedProperties.DEFAULT_ENTITY_RESOLVER);
                    } else if (DTDMapperFactory.getDTDMapper() != null) {
                        documentBuilder.setEntityResolver(new CustomEntityResolver());
                    }
                    this.dom = documentBuilder.parse(inputSource);
                    if (this.dom != null && this.dom.getDocumentElement() != null) {
                        this.dom.getDocumentElement().setUserData("path", xMLContainer.getCurrentDocumentLocation(), null);
                    }
                }
                if (!this.errorStatus) {
                    this.errorStatus = this.postAction(xMLContainer, bl);
                }
            }
            finally {
                if (inputSource.getCharacterStream() != null) {
                    inputSource.getCharacterStream().close();
                }
            }
        }
        catch (SAXException sAXException) {
            this.errorStatus = true;
        }
        catch (IOException iOException) {
            try {
                this.error(new SAXParseException(iOException.getMessage(), null));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            this.errorStatus = true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorStatus = true;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.errorStatus = true;
        }
        if (this.errorStatus) return false;
        return true;
    }

    protected boolean postAction(XMLContainer xMLContainer, boolean bl) {
        return false;
    }

    protected SAXParser buildCustomParser(XMLContainer xMLContainer) {
        return null;
    }

    public Document getDocument() {
        return this.dom;
    }

    public void dispose() {
        this.dom = null;
    }

    public boolean hasError() {
        return this.errorStatus;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.processSAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.processSAXException(sAXParseException);
    }

    private void processSAXException(SAXParseException sAXParseException) {
        this.errorStatus = true;
        if (this.editor != null) {
            boolean bl = true;
            try {
                bl = sAXParseException.getSystemId() == null || new URL(sAXParseException.getSystemId()).equals(this.editor.getXMLContainer().getCurrentDocumentLocationURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            int n = 0;
            try {
                Element element = this.editor.getDocument().getDefaultRootElement().getElement(sAXParseException.getLineNumber());
                if (element != null) {
                    n = element.getStartOffset() + sAXParseException.getColumnNumber();
                }
                this.editor.getXMLContainer().getErrorManager().notifyError(null, bl, sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), n, sAXParseException.getLocalizedMessage(), false);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.editor.getXMLContainer().getErrorManager().notifyError(sAXParseException.getMessage());
            }
        }
    }

    class CustomEntityResolver
    implements EntityResolver {
        CustomEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            InputStream inputStream;
            DTDMapper dTDMapper = DTDMapperFactory.getDTDMapper();
            if (dTDMapper != null && (inputStream = dTDMapper.getStream(string2)) != null) {
                return new InputSource(inputStream);
            }
            return new InputSource(string2);
        }
    }
}

