/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath.kit;

import com.japisoft.xpath.AbstractKit;
import com.japisoft.xpath.Navigator;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.function.Lib;
import com.japisoft.xpath.function.basic.FunctionLib;
import com.japisoft.xpath.navigator.DOMNavigator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMKit
extends AbstractKit {
    private Navigator cache;

    public DOMKit() {
        this.addFeature("http://www.japisoft.com/jxp/dom/ignorecase", false);
    }

    public Object getBetterReferenceNode(Object object) {
        if (object instanceof Document) {
            return ((Document)object).getDocumentElement();
        }
        return object;
    }

    public Lib getLibrary() {
        return new FunctionLib();
    }

    public Navigator getNavigator() {
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = new DOMNavigator();
        if (this.isFeatureSupported("http://www.japisoft.com/jxp/dom/ignorecase")) {
            ((DOMNavigator)this.cache).setIgnoreCaseMode(true);
        }
        return this.cache;
    }

    private void findSubTextNode(Node node, StringBuffer stringBuffer) {
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 3) continue;
            stringBuffer.append(node2.getNodeValue());
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (!node2.hasChildNodes() || node2.getNodeType() != 1) continue;
            this.findSubTextNode(node2, stringBuffer);
        }
    }

    public String getStringValue(Object object) {
        NodeSet nodeSet;
        if (object instanceof Node) {
            Node node = (Node)object;
            if (node.getNodeType() == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                this.findSubTextNode(node, stringBuffer);
                return stringBuffer.toString();
            }
            return node.getNodeValue();
        }
        if (object instanceof NodeSet && (nodeSet = (NodeSet)object).size() > 0) {
            Node node = (Node)nodeSet.elementAt(0);
            return this.getStringValue(node);
        }
        return object.toString();
    }

    public String getLocalName(Object object) {
        Node node = (Node)object;
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getNamespaceURI(Object object) {
        Node node = (Node)object;
        return node.getNamespaceURI();
    }

    public String getName(Object object) {
        Node node = (Node)object;
        return node.getNodeName();
    }

    public String getLang(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            String string = element.getAttribute("xml:lang");
            if ("".equals(string)) {
                if (element.getParentNode() != null) {
                    return this.getLang(element.getParentNode());
                }
                return null;
            }
            return string;
        }
        return null;
    }

    public Object getNodeForId(Object object, String string) {
        Document document = ((Node)object).getOwnerDocument();
        if (document == null) {
            throw new RuntimeException("No owner document for node " + object + " ?");
        }
        return document.getElementById(string);
    }
}

