/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.AbstractFilesCache;
import org.apache.commons.vfs.cache.FileSystemAndNameKey;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.util.Messages;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private Log log = LogFactory.getLog(SoftRefFilesCache.class);
    private final Map filesystemCache = new HashMap();
    private final Map refReverseMap = new HashMap(100);
    private final ReferenceQueue refqueue = new ReferenceQueue();
    private SoftRefReleaseThread softRefReleaseThread = null;

    private void startThread() {
        if (this.softRefReleaseThread != null) {
            throw new IllegalStateException(Messages.getString("vfs.impl/SoftRefReleaseThread-already-running.warn"));
        }
        this.softRefReleaseThread = new SoftRefReleaseThread();
        this.softRefReleaseThread.start();
    }

    private void endThread() {
        if (this.softRefReleaseThread != null) {
            this.softRefReleaseThread.requestEnd = true;
            this.softRefReleaseThread.interrupt();
            this.softRefReleaseThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject fileObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putFile: " + fileObject.getName()));
        }
        Map map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        Reference reference = this.createReference(fileObject, this.refqueue);
        FileSystemAndNameKey fileSystemAndNameKey = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
        Map map2 = map;
        synchronized (map2) {
            map.put(fileObject.getName(), reference);
            this.refReverseMap.put(reference, fileSystemAndNameKey);
        }
    }

    protected Reference createReference(FileObject fileObject, ReferenceQueue referenceQueue) {
        return new SoftReference<FileObject>(fileObject, referenceQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map map;
        Map map2 = map = this.getOrCreateFilesystemCache(fileSystem);
        synchronized (map2) {
            Reference reference = (Reference)map.get(fileName);
            if (reference == null) {
                return null;
            }
            FileObject fileObject = (FileObject)reference.get();
            if (fileObject == null) {
                this.removeFile(fileSystem, fileName);
            }
            return fileObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(FileSystem fileSystem) {
        boolean bl;
        Map map;
        Map map2 = map = this.getOrCreateFilesystemCache(fileSystem);
        synchronized (map2) {
            Iterator iterator = this.refReverseMap.values().iterator();
            while (iterator.hasNext()) {
                FileSystemAndNameKey fileSystemAndNameKey = (FileSystemAndNameKey)iterator.next();
                if (fileSystemAndNameKey.getFileSystem() != fileSystem) continue;
                iterator.remove();
                map.remove(fileSystemAndNameKey.getFileName());
            }
            bl = map.size() < 1;
        }
        if (bl) {
            this.filesystemClose(fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filesystemClose(FileSystem fileSystem) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("close fs: " + fileSystem.getRootName()));
        }
        Map map = this.filesystemCache;
        synchronized (map) {
            this.filesystemCache.remove(fileSystem);
            if (this.filesystemCache.size() < 1) {
                this.endThread();
            }
        }
        ((DefaultFileSystemManager)this.getContext().getFileSystemManager())._closeFileSystem(fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        this.endThread();
        Map map = this.filesystemCache;
        synchronized (map) {
            this.filesystemCache.clear();
        }
        this.refReverseMap.clear();
    }

    public void removeFile(FileSystem fileSystem, FileName fileName) {
        if (this.removeFile(new FileSystemAndNameKey(fileSystem, fileName))) {
            this.filesystemClose(fileSystem);
        }
    }

    public void touchFile(FileObject fileObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFile(FileSystemAndNameKey fileSystemAndNameKey) {
        Map map;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeFile: " + fileSystemAndNameKey.getFileName()));
        }
        Map map2 = map = this.getOrCreateFilesystemCache(fileSystemAndNameKey.getFileSystem());
        synchronized (map2) {
            Object v = map.remove(fileSystemAndNameKey.getFileName());
            if (v != null) {
                this.refReverseMap.remove(v);
            }
            return map.size() < 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getOrCreateFilesystemCache(FileSystem fileSystem) {
        Map map = this.filesystemCache;
        synchronized (map) {
            TreeMap treeMap;
            if (this.filesystemCache.size() < 1) {
                this.startThread();
            }
            if ((treeMap = (TreeMap)this.filesystemCache.get(fileSystem)) == null) {
                treeMap = new TreeMap();
                this.filesystemCache.put(fileSystem, treeMap);
            }
            return treeMap;
        }
    }

    private class SoftRefReleaseThread
    extends Thread {
        private boolean requestEnd = false;

        private SoftRefReleaseThread() {
            this.setName(SoftRefReleaseThread.class.getName());
            this.setDaemon(true);
        }

        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    FileSystemAndNameKey fileSystemAndNameKey;
                    Reference reference = SoftRefFilesCache.this.refqueue.remove(1000L);
                    if (reference == null || (fileSystemAndNameKey = (FileSystemAndNameKey)SoftRefFilesCache.this.refReverseMap.get(reference)) == null || !SoftRefFilesCache.this.removeFile(fileSystemAndNameKey)) continue;
                    SoftRefFilesCache.this.filesystemClose(fileSystemAndNameKey.getFileSystem());
                }
                catch (InterruptedException interruptedException) {
                    if (this.requestEnd) break;
                    VfsLog.warn(SoftRefFilesCache.this.getLogger(), SoftRefFilesCache.this.log, Messages.getString("vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }
}

