/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.FileNameParser;

public final class UriParser {
    public static String extractFirstElement(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        if (stringBuffer.charAt(0) == '/') {
            n2 = 1;
        }
        for (int i = n2; i < n; ++i) {
            if (stringBuffer.charAt(i) != '/') continue;
            String string = stringBuffer.substring(n2, i);
            stringBuffer.delete(n2, i + 1);
            return string;
        }
        String string = stringBuffer.substring(n2);
        stringBuffer.setLength(0);
        return string;
    }

    public static FileType normalisePath(StringBuffer stringBuffer) throws FileSystemException {
        FileType fileType = FileType.FOLDER;
        if (stringBuffer.length() == 0) {
            return fileType;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            fileType = FileType.FILE;
        }
        int n = 0;
        if (stringBuffer.charAt(0) == '/') {
            if (stringBuffer.length() == 1) {
                return fileType;
            }
            n = 1;
        }
        int n2 = n;
        int n3 = stringBuffer.length();
        while (n2 < n3) {
            int n4;
            for (n4 = n2; n4 < n3 && stringBuffer.charAt(n4) != '/'; ++n4) {
            }
            int n5 = n4 - n2;
            if (n5 == 0) {
                stringBuffer.delete(n4, n4 + 1);
                n3 = stringBuffer.length();
                continue;
            }
            if (n5 == 1 && stringBuffer.charAt(n2) == '.') {
                stringBuffer.delete(n2, n4 + 1);
                n3 = stringBuffer.length();
                continue;
            }
            if (n5 == 2 && stringBuffer.charAt(n2) == '.' && stringBuffer.charAt(n2 + 1) == '.') {
                int n6;
                if (n2 == n) {
                    throw new FileSystemException("vfs.provider/invalid-relative-path.error");
                }
                for (n6 = n2 - 2; n6 >= 0 && stringBuffer.charAt(n6) != '/'; --n6) {
                }
                n2 = n6 + 1;
                stringBuffer.delete(n2, n4 + 1);
                n3 = stringBuffer.length();
                continue;
            }
            n2 = n4 + 1;
        }
        if (!VFS.isUriStyle() && n3 > 0 && stringBuffer.charAt(n3 - 1) == '/' && n3 > 1) {
            stringBuffer.delete(n3 - 1, n3);
        }
        return fileType;
    }

    public static boolean fixSeparators(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\\') continue;
            stringBuffer.setCharAt(i, '/');
            bl = true;
        }
        return bl;
    }

    public static String extractScheme(String string) {
        return UriParser.extractScheme(string, null);
    }

    public static String extractScheme(String string, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.setLength(0);
            stringBuffer.append(string);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                String string2 = string.substring(0, i);
                if (stringBuffer != null) {
                    stringBuffer.delete(0, i + 1);
                }
                return string2.intern();
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (i <= 0 || (c < '0' || c > '9') && c != '+' && c != '-' && c != '.')) break;
        }
        return null;
    }

    public static String decode(String string) throws FileSystemException {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        UriParser.decode(stringBuffer, 0, stringBuffer.length());
        return stringBuffer.toString();
    }

    public static void decode(StringBuffer stringBuffer, int n, int n2) throws FileSystemException {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            char c = stringBuffer.charAt(n3);
            if (c == '%') {
                if (n4 < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuffer.substring(n3, n3 + n4));
                }
                int n5 = Character.digit(stringBuffer.charAt(n3 + 1), 16);
                int n6 = Character.digit(stringBuffer.charAt(n3 + 2), 16);
                if (n5 == -1 || n6 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuffer.substring(n3, n3 + 3));
                }
                char c2 = (char)(n5 << 4 | n6);
                stringBuffer.setCharAt(n3, c2);
                stringBuffer.delete(n3 + 1, n3 + 3);
                n4 -= 2;
            }
            --n4;
            ++n3;
        }
    }

    public static void appendEncoded(StringBuffer stringBuffer, String string, char[] cArray) {
        int n = stringBuffer.length();
        stringBuffer.append(string);
        UriParser.encode(stringBuffer, n, string.length(), cArray);
    }

    public static void encode(StringBuffer stringBuffer, int n, int n2, char[] cArray) {
        int n3 = n;
        for (int i = n2; i > 0; --i) {
            boolean bl;
            char c = stringBuffer.charAt(n3);
            boolean bl2 = bl = c == '%';
            if (cArray != null) {
                for (int j = 0; !bl && j < cArray.length; ++j) {
                    if (c != cArray[j]) continue;
                    bl = true;
                }
            }
            if (bl) {
                char[] cArray2 = new char[]{Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
                stringBuffer.setCharAt(n3, '%');
                stringBuffer.insert(n3 + 1, cArray2);
                n3 += 2;
            }
            ++n3;
        }
    }

    public static String encode(String string) {
        return UriParser.encode(string, null);
    }

    public static String encode(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        UriParser.encode(stringBuffer, 0, stringBuffer.length(), cArray);
        return stringBuffer.toString();
    }

    public static String[] encode(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = UriParser.encode(stringArray[i]);
        }
        return stringArray;
    }

    public static void checkUriEncoding(String string) throws FileSystemException {
        UriParser.decode(string);
    }

    public static void canonicalizePath(StringBuffer stringBuffer, int n, int n2, FileNameParser fileNameParser) throws FileSystemException {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            char c = stringBuffer.charAt(n3);
            if (c == '%') {
                boolean bl;
                if (n4 < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuffer.substring(n3, n3 + n4));
                }
                int n5 = Character.digit(stringBuffer.charAt(n3 + 1), 16);
                int n6 = Character.digit(stringBuffer.charAt(n3 + 2), 16);
                if (n5 == -1 || n6 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuffer.substring(n3, n3 + 3));
                }
                char c2 = (char)(n5 << 4 | n6);
                boolean bl2 = bl = c2 == '%' || fileNameParser != null && fileNameParser.encodeCharacter(c2);
                if (bl) {
                    n3 += 2;
                    n4 -= 2;
                } else {
                    stringBuffer.setCharAt(n3, c2);
                    stringBuffer.delete(n3 + 1, n3 + 3);
                    n4 -= 2;
                }
            } else if (fileNameParser.encodeCharacter(c)) {
                char[] cArray = new char[]{Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
                stringBuffer.setCharAt(n3, '%');
                stringBuffer.insert(n3 + 1, cArray);
                n3 += 2;
            }
            --n4;
            ++n3;
        }
    }

    public static String extractQueryString(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '?') continue;
            String string = stringBuffer.substring(i + 1);
            stringBuffer.delete(i, stringBuffer.length());
            return string;
        }
        return null;
    }
}

