/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.util.Messages;

public class DelegatingFileSystemOptionsBuilder {
    private Log log = LogFactory.getLog(DelegatingFileSystemOptionsBuilder.class);
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private final FileSystemManager manager;
    private final Map beanMethods = new TreeMap();
    private static final Map primitiveToObject = new TreeMap();

    public DelegatingFileSystemOptionsBuilder(FileSystemManager fileSystemManager) {
        this.manager = fileSystemManager;
    }

    protected FileSystemManager getManager() {
        return this.manager;
    }

    public void setConfigString(FileSystemOptions fileSystemOptions, String string, String string2, String string3) throws FileSystemException {
        this.setConfigStrings(fileSystemOptions, string, string2, new String[]{string3});
    }

    public void setConfigStrings(FileSystemOptions fileSystemOptions, String string, String string2, String[] stringArray) throws FileSystemException {
        Context context = new Context(fileSystemOptions, string, string2, stringArray);
        this.setValues(context);
    }

    public void setConfigClass(FileSystemOptions fileSystemOptions, String string, String string2, Class clazz) throws FileSystemException, IllegalAccessException, InstantiationException {
        this.setConfigClasses(fileSystemOptions, string, string2, new Class[]{clazz});
    }

    public void setConfigClasses(FileSystemOptions fileSystemOptions, String string, String string2, Class[] classArray) throws FileSystemException, IllegalAccessException, InstantiationException {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = classArray[i].newInstance();
        }
        Context context = new Context(fileSystemOptions, string, string2, objectArray);
        this.setValues(context);
    }

    private void setValues(Context context) throws FileSystemException {
        if (!this.fillConfigSetters(context)) {
            throw new FileSystemException("vfs.provider/config-key-invalid.error", new String[]{context.scheme, context.name});
        }
        context.fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(context.scheme);
        for (Method method : context.configSetters) {
            if (!this.convertValuesAndInvoke(method, context)) continue;
            return;
        }
        throw new FileSystemException("vfs.provider/config-value-invalid.error", new Object[]{context.scheme, context.name, context.values});
    }

    private boolean convertValuesAndInvoke(Method method, Context context) throws FileSystemException {
        Method method2;
        Constructor<?> constructor;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length < 2) {
            return false;
        }
        if (!classArray[0].isAssignableFrom(FileSystemOptions.class)) {
            return false;
        }
        Class<?> clazz3 = classArray[1];
        if (clazz3.isArray()) {
            clazz2 = clazz3.getComponentType();
        } else {
            if (context.values.length > 1) {
                return false;
            }
            clazz2 = clazz3;
        }
        if (clazz2.isPrimitive()) {
            clazz = (Class<?>)primitiveToObject.get(clazz2.getName());
            if (clazz == null) {
                this.log.warn((Object)Messages.getString("vfs.provider/config-unexpected-primitive.error", clazz2.getName()));
                return false;
            }
            clazz2 = clazz;
        }
        if (clazz2.isAssignableFrom(clazz = context.values[0].getClass())) {
            this.invokeSetter(clazz3, context, method, context.values);
            return true;
        }
        if (clazz != String.class) {
            this.log.warn((Object)Messages.getString("vfs.provider/config-unexpected-value-class.error", new String[]{clazz.getName(), context.scheme, context.name}));
            return false;
        }
        Object object = Array.newInstance(clazz2, context.values.length);
        try {
            constructor = clazz2.getConstructor(STRING_PARAM);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            constructor = null;
        }
        if (constructor != null) {
            for (int i = 0; i < context.values.length; ++i) {
                try {
                    Array.set(object, i, constructor.newInstance(context.values[i]));
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    throw new FileSystemException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FileSystemException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FileSystemException(invocationTargetException);
                }
            }
            this.invokeSetter(clazz3, context, method, object);
            return true;
        }
        try {
            method2 = clazz2.getMethod("valueOf", STRING_PARAM);
            if (!Modifier.isStatic(method2.getModifiers())) {
                method2 = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method2 = null;
        }
        if (method2 != null) {
            for (int i = 0; i < context.values.length; ++i) {
                try {
                    Array.set(object, i, method2.invoke(null, context.values[i]));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new FileSystemException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new FileSystemException(invocationTargetException);
                }
            }
            this.invokeSetter(clazz3, context, method, object);
            return true;
        }
        return false;
    }

    private void invokeSetter(Class clazz, Context context, Method method, Object object) throws FileSystemException {
        Object[] objectArray = clazz.isArray() ? new Object[]{context.fso, object} : new Object[]{context.fso, Array.get(object, 0)};
        try {
            method.invoke((Object)context.fileSystemConfigBuilder, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FileSystemException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FileSystemException(invocationTargetException);
        }
    }

    private boolean fillConfigSetters(Context context) throws FileSystemException {
        Map map = this.getSchemeMethods(context.scheme);
        List list = (List)map.get(context.name.toLowerCase());
        if (list == null) {
            return false;
        }
        context.configSetters = list;
        return true;
    }

    private Map getSchemeMethods(String string) throws FileSystemException {
        Map map = (Map)this.beanMethods.get(string);
        if (map == null) {
            map = this.createSchemeMethods(string);
            this.beanMethods.put(string, map);
        }
        return map;
    }

    private Map createSchemeMethods(String string) throws FileSystemException {
        FileSystemConfigBuilder fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(string);
        if (fileSystemConfigBuilder == null) {
            throw new FileSystemException("vfs.provider/no-config-builder.error", string);
        }
        TreeMap<String, ArrayList<Method>> treeMap = new TreeMap<String, ArrayList<Method>>();
        Method[] methodArray = fileSystemConfigBuilder.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string2;
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || !(string2 = method.getName()).startsWith("set")) continue;
            String string3 = string2.substring(3).toLowerCase();
            ArrayList<Method> arrayList = (ArrayList<Method>)treeMap.get(string3);
            if (arrayList == null) {
                arrayList = new ArrayList<Method>(2);
                treeMap.put(string3, arrayList);
            }
            arrayList.add(method);
        }
        return treeMap;
    }

    static {
        primitiveToObject.put(Void.TYPE.getName(), Void.class);
        primitiveToObject.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveToObject.put(Byte.TYPE.getName(), Byte.class);
        primitiveToObject.put(Character.TYPE.getName(), Character.class);
        primitiveToObject.put(Short.TYPE.getName(), Short.class);
        primitiveToObject.put(Integer.TYPE.getName(), Integer.class);
        primitiveToObject.put(Long.TYPE.getName(), Long.class);
        primitiveToObject.put(Double.TYPE.getName(), Double.class);
        primitiveToObject.put(Float.TYPE.getName(), Float.class);
    }

    private static class Context {
        private final FileSystemOptions fso;
        private final String scheme;
        private final String name;
        private final Object[] values;
        private List configSetters;
        private FileSystemConfigBuilder fileSystemConfigBuilder;

        private Context(FileSystemOptions fileSystemOptions, String string, String string2, Object[] objectArray) {
            this.fso = fileSystemOptions;
            this.scheme = string;
            this.name = string2;
            this.values = objectArray;
        }
    }
}

