/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NamespaceNode
implements Node {
    private Node parent;
    private String name;
    private String value;
    private HashMap userData = new HashMap();

    public NamespaceNode(Node node, String string, String string2) {
        this.parent = node;
        this.name = string;
        this.value = string2;
    }

    NamespaceNode(Node node, Node node2) {
        String string = node2.getNodeName();
        this.name = string.equals("xmlns") ? "" : (string.startsWith("xmlns:") ? string.substring(6) : string);
        this.parent = node;
        this.value = node2.getNodeValue();
    }

    public String getNodeName() {
        return this.name;
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeValue(String string) throws DOMException {
        this.disallowModification();
    }

    public short getNodeType() {
        return 13;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new EmptyNodeList();
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getOwnerDocument();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.disallowModification();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.disallowModification();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        this.disallowModification();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        this.disallowModification();
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean bl) {
        return new NamespaceNode(this.parent, this.name, this.value);
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        this.disallowModification();
    }

    public String getLocalName() {
        return this.name;
    }

    public boolean hasAttributes() {
        return false;
    }

    private void disallowModification() throws DOMException {
        throw new DOMException(7, "Namespace node may not be modified");
    }

    public int hashCode() {
        return this.hashCode(this.parent) + this.hashCode(this.name) + this.hashCode(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof NamespaceNode) {
            NamespaceNode namespaceNode = (NamespaceNode)object;
            return this.equals(this.parent, namespaceNode.getParentNode()) && this.equals(this.name, namespaceNode.getNodeName()) && this.equals(this.value, namespaceNode.getNodeValue());
        }
        return false;
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    private boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        DOMException dOMException = new DOMException(9, "DOM level 3 interfaces are not fully implemented in Jaxen's NamespaceNode class");
        throw dOMException;
    }

    public String getTextContent() {
        return this.value;
    }

    public void setTextContent(String string) throws DOMException {
        this.disallowModification();
    }

    public boolean isSameNode(Node node) {
        return this.isEqualNode(node) && this.getParentNode() == node.getParentNode();
    }

    public String lookupPrefix(String string) {
        throw new UnsupportedOperationException("Changing interfaces in a JDK blows chunks!");
    }

    public boolean isDefaultNamespace(String string) {
        return string.equals(this.lookupNamespaceURI(null));
    }

    public String lookupNamespaceURI(String string) {
        throw new UnsupportedOperationException("Changing interfaces in a JDK blows chunks!");
    }

    public boolean isEqualNode(Node node) {
        if (node.getNodeType() == this.getNodeType()) {
            NamespaceNode namespaceNode = (NamespaceNode)node;
            if (namespaceNode.name == null && this.name != null) {
                return false;
            }
            if (namespaceNode.name != null && this.name == null) {
                return false;
            }
            if (namespaceNode.value == null && this.value != null) {
                return false;
            }
            if (namespaceNode.value != null && this.value == null) {
                return false;
            }
            if (namespaceNode.name == null && this.name == null) {
                return namespaceNode.value.equals(this.value);
            }
            return namespaceNode.name.equals(this.name) && namespaceNode.value.equals(this.value);
        }
        return false;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        Object object2 = this.getUserData(string);
        this.userData.put(string, object);
        return object2;
    }

    public Object getUserData(String string) {
        return this.userData.get(string);
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }
    }
}

