/*
 * Decompiled with CFR 0.152.
 */
package test.dom;

import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.dom.DomNodeFactory;
import com.japisoft.fastparser.sax.Sax2Parser;
import com.japisoft.fastparser.tools.TraceContentHandler;
import java.io.FileInputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Demo {
    static void walkAndWrite(int n, Node node) {
        if (node instanceof Text) {
            node.setNodeValue("TEXT OK");
            System.out.println(node.getNodeValue());
        } else if (node instanceof Comment) {
            System.out.println(" <!-- " + node.getNodeValue() + "-->");
        } else if (node instanceof Element) {
            String string = "<" + ((Element)node).getTagName();
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                string = string + " ";
                string = string + attr.getNodeName() + "=" + "\"" + attr.getNodeValue() + "\"";
            }
            if (!node.hasChildNodes()) {
                string = string + "/>";
                System.out.println(string);
            } else {
                string = string + ">";
                System.out.println(string);
                NodeList nodeList = ((Element)node).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Demo.walkAndWrite(n + 1, nodeList.item(i));
                }
                System.out.println("</" + node.getNodeName() + ">");
            }
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        Node node;
        int n;
        Sax2Parser sax2Parser = new Sax2Parser();
        sax2Parser.setContentHandler(new TraceContentHandler());
        sax2Parser.setInputStream(new FileInputStream("/home/japisoft/xml-samples/test2.xml"));
        sax2Parser.parse();
        Parser parser = new Parser();
        parser.setNodeFactory(new DomNodeFactory());
        parser.setInputStream(new FileInputStream("/home/japisoft/test1.xml"));
        parser.parse();
        Document document = parser.getDocument();
        Element element = (Element)((Object)document.getRoot());
        NodeList nodeList = element.getElementsByTagName("url");
        element.setAttribute("id2", "ok2");
        element.setAttribute("id2", "ok3");
        element.removeAttribute("id2");
        System.out.println("SHOW FOUND TAGS");
        System.out.println("ROOT = " + element);
        NodeList nodeList2 = element.getElementsByTagName("B");
        System.out.println("DESCENDANT B: ");
        for (n = 0; n < nodeList2.getLength(); ++n) {
            node = nodeList2.item(n);
            System.out.println("-" + node.getNodeName());
        }
        nodeList2 = element.getOwnerDocument().getElementsByTagName("C");
        System.out.println("DESCENDANT C: ");
        for (n = 0; n < nodeList2.getLength(); ++n) {
            node = nodeList2.item(n);
            System.out.println("-" + node.getNodeName());
        }
        System.out.println("-----------------------");
        Demo.walkAndWrite(0, element);
        Comment comment = element.getOwnerDocument().createComment("TEST 2");
        node = element.getOwnerDocument().createElement("TEST2");
        Node node2 = element.getOwnerDocument().createAttribute("id");
        node2.setNodeValue("val1");
        node.appendChild(node2);
        element.appendChild(comment);
        node2 = element.appendChild(node2);
        node2.setNodeValue("val2");
        Text text = element.getOwnerDocument().createTextNode("TEST DE TEXT");
        element.appendChild(text);
        text.setNodeValue("TEST2 DE TEXT");
        System.out.println("-----------------------");
        Demo.walkAndWrite(0, element);
        System.exit(0);
    }
}

