/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.DbLogc;

public class LogCursor {
    DbLogc logc;

    LogCursor(DbLogc logc) {
        this.logc = logc;
    }

    static LogCursor wrap(DbLogc logc) {
        return logc == null ? null : new LogCursor(logc);
    }

    public synchronized void close() throws DatabaseException {
        this.logc.close(0);
    }

    public OperationStatus getCurrent(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 6));
    }

    public OperationStatus getNext(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 16));
    }

    public OperationStatus getFirst(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 7));
    }

    public OperationStatus getLast(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 15));
    }

    public OperationStatus getPrev(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 23));
    }

    public OperationStatus set(LogSequenceNumber lsn, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(lsn, data, 26));
    }

    public int version() throws DatabaseException {
        return this.logc.version(0);
    }
}

