/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CodeTableHandler
extends DefaultHandler {
    private Hashtable sets;
    private Hashtable charset;
    private Hashtable combiningchars;
    private Integer isocode;
    private Integer marc;
    private Character ucs;
    private boolean iscombining;
    private Vector combining;
    private String tag;
    private StringBuffer data;
    private Locator locator;

    public Hashtable getCharSets() {
        return this.sets;
    }

    public Hashtable getCombiningChars() {
        return this.combiningchars;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
        if (string2.equals("characterSet")) {
            this.charset = new Hashtable();
            this.isocode = Integer.valueOf(attributes.getValue("ISOcode"), 16);
            this.combining = new Vector();
        } else if (string2.equals("marc")) {
            this.data = new StringBuffer();
        } else if (string2.equals("codeTables")) {
            this.sets = new Hashtable();
            this.combiningchars = new Hashtable();
        } else if (string2.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (string2.equals("isCombining")) {
            this.data = new StringBuffer();
        } else if (string2.equals("code")) {
            this.iscombining = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.data != null) {
            this.data.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXParseException {
        if (string2.equals("characterSet")) {
            this.sets.put(this.isocode, this.charset);
            this.combiningchars.put(this.isocode, this.combining);
            this.combining = null;
            this.charset = null;
        } else if (string2.equals("marc")) {
            this.marc = Integer.valueOf(this.data.toString(), 16);
        } else if (string2.equals("ucs")) {
            this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
        } else if (string2.equals("code")) {
            if (this.iscombining) {
                this.combining.add(this.marc);
            }
            this.charset.put(this.marc, this.ucs);
        } else if (string2.equals("isCombining") && this.data.toString().equals("true")) {
            this.iscombining = true;
        }
        this.data = null;
    }

    public static void main(String[] stringArray) {
        Hashtable hashtable = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            File file = new File("C:\\Documents and Settings\\ckeith\\Desktop\\Projects\\Code Tables\\codetables.xml");
            InputSource inputSource = new InputSource(new FileInputStream(file));
            CodeTableHandler codeTableHandler = new CodeTableHandler();
            xMLReader.setContentHandler(codeTableHandler);
            xMLReader.parse(inputSource);
            hashtable = codeTableHandler.getCharSets();
            System.out.println(codeTableHandler.getCombiningChars());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

