/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.helpers.ErrorHandlerImpl;
import org.marc4j.marcxml.Converter;
import org.marc4j.marcxml.MarcXmlReader;
import org.marc4j.util.AnselToUnicode;
import org.marc4j.util.Iso5426ToUnicode;
import org.marc4j.util.Iso6937ToUnicode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class MarcXmlWriter {
    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string4 = null;
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-xsl")) {
                if (n == stringArray.length - 1) {
                    MarcXmlWriter.usage();
                }
                string3 = stringArray[++n].trim();
            } else if (stringArray[n].equals("-out")) {
                if (n == stringArray.length - 1) {
                    MarcXmlWriter.usage();
                }
                string2 = stringArray[++n].trim();
            } else if (stringArray[n].equals("-dtd")) {
                bl = true;
            } else if (stringArray[n].equals("-xsd")) {
                bl2 = true;
            } else if (stringArray[n].equals("-convert")) {
                if (n == stringArray.length - 1) {
                    MarcXmlWriter.usage();
                }
                string4 = stringArray[++n].trim();
            } else if (stringArray[n].equals("-usage")) {
                MarcXmlWriter.usage();
            } else if (stringArray[n].equals("-help")) {
                MarcXmlWriter.usage();
            } else {
                string = stringArray[n].trim();
                if (n != stringArray.length - 1) {
                    MarcXmlWriter.usage();
                }
            }
            ++n;
        }
        if (string == null) {
            MarcXmlWriter.usage();
        }
        try {
            Object object;
            MarcXmlReader marcXmlReader = new MarcXmlReader();
            marcXmlReader.setProperty("http://marc4j.org/properties/error-handler", new ErrorHandlerImpl());
            if (bl2) {
                marcXmlReader.setProperty("http://marc4j.org/properties/schema-location", "http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd");
            }
            if (string4 != null) {
                object = null;
                if ("ANSEL".equals(string4)) {
                    object = new AnselToUnicode();
                } else if ("ISO5426".equals(string4)) {
                    object = new Iso5426ToUnicode();
                } else if ("ISO6937".equals(string4)) {
                    object = new Iso6937ToUnicode();
                } else {
                    System.err.println("Unknown character set");
                    System.exit(1);
                }
                marcXmlReader.setProperty("http://marc4j.org/properties/character-conversion", object);
            }
            object = string4 != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "ISO8859_1")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF8"));
            InputSource inputSource = new InputSource((Reader)object);
            SAXSource sAXSource = new SAXSource(marcXmlReader, inputSource);
            BufferedWriter bufferedWriter = string2 == null ? new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8")) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF8"));
            StreamResult streamResult = new StreamResult(bufferedWriter);
            Converter converter = new Converter();
            if (string3 != null) {
                StreamSource streamSource = new StreamSource(new File(string3).toURL().toString());
                converter.convert((Source)streamSource, (Source)sAXSource, streamResult);
            } else {
                converter.convert(sAXSource, streamResult);
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace(System.err);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        System.err.println("Total time: " + (System.currentTimeMillis() - l) + " miliseconds");
    }

    private static void usage() {
        System.err.println("MARC4J version beta 7, Copyright (C) 2002-2003 Bas Peters");
        System.err.println("Usage: org.marc4j.util.MarcXmlWriter [-options] <file.xml>");
        System.err.println("       -xsd = Add W3C XML Schema Location to root element");
        System.err.println("       -xsl <file> = Postprocess MARCXML using XSLT stylesheet <file>");
        System.err.println("       -out <file> = Output using <file>");
        System.err.println("       -convert [ANSEL | ISO5426 | ISO6937] = convert to UTF-8 using");
        System.err.println("          specified character set");
        System.err.println("       -usage or -help = this message");
        System.err.println("Without a stylesheet the program outputs well-formed MARCXML");
        System.err.println("See http://marc4j.tigris.org for more information.");
        System.exit(1);
    }
}

