/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLSerializable;
import com.topologi.diffx.xml.XMLWritable;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class XMLSerializer {
    private static final DateFormat DF = new SimpleDateFormat("dd/MM/yyyy");
    private XMLWriter xml;

    public XMLSerializer(XMLWriter xMLWriter) {
        this.xml = xMLWriter;
    }

    public XMLWriter getXML() {
        return this.xml;
    }

    public void serialize(Object object, String string) throws IOException {
        if (object != null) {
            if (string.lastIndexOf(46) != -1) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            if (string.lastIndexOf(36) != -1) {
                string = string.substring(string.lastIndexOf(36) + 1);
            }
            string = string.toLowerCase();
            if (object instanceof Number) {
                this.xml.openElement(string, false);
                this.xml.writeText(object.toString());
                this.xml.closeElement();
            } else if (object instanceof String) {
                this.xml.openElement(string, false);
                this.xml.writeText(object.toString());
                this.xml.closeElement();
            } else if (object instanceof Character) {
                this.xml.openElement(string, false);
                this.xml.writeText(((Character)object).charValue());
                this.xml.closeElement();
            } else if (object instanceof Boolean) {
                this.xml.openElement(string, false);
                this.xml.writeText(object.toString());
                this.xml.closeElement();
            } else if (object instanceof Date) {
                this.xml.openElement(string, false);
                this.xml.writeText(DF.format((Date)object));
                this.xml.closeElement();
            } else if (object instanceof Collection) {
                this.xml.openElement(string, ((Collection)object).size() != 0);
                this.serializeCollection((Collection)object);
                this.xml.closeElement();
            } else if (object instanceof Hashtable) {
                this.xml.openElement(string, ((Hashtable)object).size() != 0);
                this.serializeHashtable((Hashtable)object);
                this.xml.closeElement();
            } else {
                this.xml.openElement(string, true);
                this.serializeObject(object);
                this.xml.closeElement();
            }
        }
    }

    public void serializeCollection(Collection collection) throws IOException {
        for (Object e : collection) {
            this.serialize(e, e.getClass().getName());
        }
    }

    public void serializeHashtable(Hashtable hashtable) throws IOException {
        this.xml.openElement("map", !hashtable.isEmpty());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            this.xml.openElement("element");
            this.xml.openElement("key");
            this.serialize(k, "key");
            this.xml.closeElement();
            this.xml.openElement("value");
            this.serialize(v, "value");
            this.xml.closeElement();
            this.xml.closeElement();
        }
        this.xml.closeElement();
    }

    public void serializeObject(Object object) throws IOException {
        if (object instanceof XMLSerializable) {
            try {
                Object[] objectArray = new Object[]{};
                Class<?> clazz = object.getClass();
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    String string = methodArray[i].getName();
                    if (!string.startsWith("get") || string.equals("getClass")) continue;
                    Object object2 = methodArray[i].invoke(object, objectArray);
                    String string2 = string.substring(3).toLowerCase();
                    this.serialize(object2, string2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
        } else if (object instanceof XMLWritable) {
            ((XMLWritable)object).toXML(this.xml);
        }
    }
}

